/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.streaming.runtime.io.AlignedController;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierBehaviourController;
import org.apache.flink.streaming.runtime.io.UnalignedController;
import org.apache.flink.util.Preconditions;

@Internal
public class AlternatingController
implements CheckpointBarrierBehaviourController {
    private final AlignedController alignedController;
    private final UnalignedController unalignedController;
    private CheckpointBarrierBehaviourController activeController;

    public AlternatingController(AlignedController alignedController, UnalignedController unalignedController) {
        this.alignedController = alignedController;
        this.activeController = this.alignedController;
        this.unalignedController = unalignedController;
    }

    @Override
    public void barrierReceived(InputChannelInfo channelInfo, CheckpointBarrier barrier) {
        this.checkActiveController(barrier);
        this.activeController.barrierReceived(channelInfo, barrier);
    }

    @Override
    public boolean preProcessFirstBarrier(InputChannelInfo channelInfo, CheckpointBarrier barrier) throws IOException, CheckpointException {
        this.activeController = this.chooseController(barrier);
        return this.activeController.preProcessFirstBarrier(channelInfo, barrier);
    }

    @Override
    public boolean postProcessLastBarrier(InputChannelInfo channelInfo, CheckpointBarrier barrier) throws IOException {
        this.checkActiveController(barrier);
        return this.activeController.postProcessLastBarrier(channelInfo, barrier);
    }

    @Override
    public void abortPendingCheckpoint(long cancelledId, CheckpointException exception) throws IOException {
        this.activeController.abortPendingCheckpoint(cancelledId, exception);
    }

    @Override
    public void obsoleteBarrierReceived(InputChannelInfo channelInfo, CheckpointBarrier barrier) throws IOException {
        this.chooseController(barrier).obsoleteBarrierReceived(channelInfo, barrier);
    }

    private void checkActiveController(CheckpointBarrier barrier) {
        if (this.isAligned(barrier)) {
            Preconditions.checkState((this.activeController == this.alignedController ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((this.activeController == this.unalignedController ? 1 : 0) != 0);
        }
    }

    private boolean isAligned(CheckpointBarrier barrier) {
        return barrier.getCheckpointOptions().needsAlignment();
    }

    private CheckpointBarrierBehaviourController chooseController(CheckpointBarrier barrier) {
        return this.isAligned(barrier) ? this.alignedController : this.unalignedController;
    }
}

