/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.BroadcastStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class BroadcastStateTransformation<IN1, IN2, OUT>
extends PhysicalTransformation<OUT> {
    private final Transformation<IN1> nonBroadcastStream;
    private final Transformation<IN2> broadcastStream;
    private final StreamOperatorFactory<OUT> operatorFactory;
    private final TypeInformation<?> stateKeyType;
    private final KeySelector<IN1, ?> keySelector;

    private BroadcastStateTransformation(String name, Transformation<IN1> inputStream, Transformation<IN2> broadcastStream, StreamOperatorFactory<OUT> operatorFactory, @Nullable TypeInformation<?> keyType, @Nullable KeySelector<IN1, ?> keySelector, TypeInformation<OUT> outTypeInfo, int parallelism) {
        super(name, outTypeInfo, parallelism);
        this.nonBroadcastStream = (Transformation)Preconditions.checkNotNull(inputStream);
        this.broadcastStream = (Transformation)Preconditions.checkNotNull(broadcastStream);
        this.operatorFactory = (StreamOperatorFactory)Preconditions.checkNotNull(operatorFactory);
        this.stateKeyType = keyType;
        this.keySelector = keySelector;
        this.updateManagedMemoryStateBackendUseCase(keySelector != null);
    }

    public Transformation<IN2> getBroadcastStream() {
        return this.broadcastStream;
    }

    public Transformation<IN1> getNonBroadcastStream() {
        return this.nonBroadcastStream;
    }

    public StreamOperatorFactory<OUT> getOperatorFactory() {
        return this.operatorFactory;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    public KeySelector<IN1, ?> getKeySelector() {
        return this.keySelector;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.getChainingStrategy();
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList predecessors = new ArrayList();
        predecessors.add(this);
        predecessors.add(this.nonBroadcastStream);
        predecessors.add(this.broadcastStream);
        return predecessors;
    }

    public List<Transformation<?>> getInputs() {
        ArrayList predecessors = new ArrayList();
        predecessors.add(this.nonBroadcastStream);
        predecessors.add(this.broadcastStream);
        return predecessors;
    }

    public static <IN1, IN2, OUT> BroadcastStateTransformation<IN1, IN2, OUT> forNonKeyedStream(String name, DataStream<IN1> nonBroadcastStream, BroadcastStream<IN2> broadcastStream, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outTypeInfo, int parallelism) {
        return new BroadcastStateTransformation(name, ((DataStream)Preconditions.checkNotNull(nonBroadcastStream)).getTransformation(), ((BroadcastStream)Preconditions.checkNotNull(broadcastStream)).getTransformation(), operatorFactory, null, null, outTypeInfo, parallelism);
    }

    public static <IN1, IN2, OUT> BroadcastStateTransformation<IN1, IN2, OUT> forKeyedStream(String name, KeyedStream<IN1, ?> nonBroadcastStream, BroadcastStream<IN2> broadcastStream, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outTypeInfo, int parallelism) {
        return new BroadcastStateTransformation(name, ((KeyedStream)Preconditions.checkNotNull(nonBroadcastStream)).getTransformation(), ((BroadcastStream)Preconditions.checkNotNull(broadcastStream)).getTransformation(), operatorFactory, nonBroadcastStream.getKeyType(), nonBroadcastStream.getKeySelector(), outTypeInfo, parallelism);
    }
}

