/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;

public class OperatorSnapshotUtil {
    public static String getResourceFilename(String filename) {
        ClassLoader cl = OperatorSnapshotUtil.class.getClassLoader();
        URL resource = cl.getResource(filename);
        return resource.getFile();
    }

    public static void writeStateHandle(OperatorSubtaskState state, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        try (DataOutputStream dos = new DataOutputStream(out);){
            dos.writeInt(3);
            MetadataV3Serializer.serializeStreamStateHandle(null, (DataOutputStream)dos);
            StateObjectCollection rawOperatorState = state.getRawOperatorState();
            if (rawOperatorState != null) {
                dos.writeInt(rawOperatorState.size());
                for (Object operatorStateHandle : rawOperatorState) {
                    MetadataV3Serializer.serializeOperatorStateHandleUtil((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedOperatorState = state.getManagedOperatorState();
            if (managedOperatorState != null) {
                dos.writeInt(managedOperatorState.size());
                for (Object operatorStateHandle : managedOperatorState) {
                    MetadataV3Serializer.serializeOperatorStateHandleUtil((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection rawKeyedState = state.getRawKeyedState();
            if (rawKeyedState != null) {
                dos.writeInt(rawKeyedState.size());
                for (Object keyedStateHandle : rawKeyedState) {
                    MetadataV3Serializer.serializeKeyedStateHandleUtil((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedKeyedState = state.getManagedKeyedState();
            if (managedKeyedState != null) {
                dos.writeInt(managedKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : managedKeyedState) {
                    MetadataV3Serializer.serializeKeyedStateHandleUtil((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection inputChannelStateHandles = state.getInputChannelState();
            dos.writeInt(inputChannelStateHandles.size());
            for (InputChannelStateHandle inputChannelStateHandle : inputChannelStateHandles) {
                MetadataV3Serializer.INSTANCE.serializeInputChannelStateHandle(inputChannelStateHandle, dos);
            }
            StateObjectCollection resultSubpartitionStateHandles = state.getResultSubpartitionState();
            dos.writeInt(inputChannelStateHandles.size());
            for (ResultSubpartitionStateHandle resultSubpartitionStateHandle : resultSubpartitionStateHandles) {
                MetadataV3Serializer.INSTANCE.serializeResultSubpartitionStateHandle(resultSubpartitionStateHandle, dos);
            }
            dos.flush();
        }
    }

    public static OperatorSubtaskState readStateHandle(String path) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(path);
        try (DataInputStream dis = new DataInputStream(in);){
            int v = dis.readInt();
            MetadataV3Serializer.deserializeStreamStateHandle((DataInputStream)dis);
            ArrayList<OperatorStateHandle> rawOperatorState = null;
            int numRawOperatorStates = dis.readInt();
            if (numRawOperatorStates >= 0) {
                rawOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numRawOperatorStates; ++i) {
                    OperatorStateHandle operatorState = MetadataV3Serializer.deserializeOperatorStateHandleUtil((DataInputStream)dis);
                    rawOperatorState.add(operatorState);
                }
            }
            ArrayList<OperatorStateHandle> managedOperatorState = null;
            int numManagedOperatorStates = dis.readInt();
            if (numManagedOperatorStates >= 0) {
                managedOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numManagedOperatorStates; ++i) {
                    OperatorStateHandle operatorState = MetadataV3Serializer.deserializeOperatorStateHandleUtil((DataInputStream)dis);
                    managedOperatorState.add(operatorState);
                }
            }
            ArrayList<KeyedStateHandle> rawKeyedState = null;
            int numRawKeyedStates = dis.readInt();
            if (numRawKeyedStates >= 0) {
                rawKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numRawKeyedStates; ++i) {
                    KeyedStateHandle keyedState = MetadataV3Serializer.deserializeKeyedStateHandleUtil((DataInputStream)dis);
                    rawKeyedState.add(keyedState);
                }
            }
            ArrayList<KeyedStateHandle> managedKeyedState = null;
            int numManagedKeyedStates = dis.readInt();
            if (numManagedKeyedStates >= 0) {
                managedKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numManagedKeyedStates; ++i) {
                    KeyedStateHandle keyedState = MetadataV3Serializer.deserializeKeyedStateHandleUtil((DataInputStream)dis);
                    managedKeyedState.add(keyedState);
                }
            }
            StateObjectCollection inputChannelStateHandles = v == 3 ? MetadataV3Serializer.deserializeInputChannelStateHandle((DataInputStream)dis) : StateObjectCollection.empty();
            StateObjectCollection resultSubpartitionStateHandles = v == 3 ? MetadataV3Serializer.INSTANCE.deserializeResultSubpartitionStateHandle(dis) : StateObjectCollection.empty();
            OperatorSubtaskState operatorSubtaskState = new OperatorSubtaskState(new StateObjectCollection(managedOperatorState), new StateObjectCollection(rawOperatorState), new StateObjectCollection(managedKeyedState), new StateObjectCollection(rawKeyedState), inputChannelStateHandles, resultSubpartitionStateHandles);
            return operatorSubtaskState;
        }
    }
}

