/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.util.Preconditions;

public class OneInputStreamOperatorTestHarness<IN, OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    private final List<Input> inputs = new ArrayList<Input>();
    private long currentWatermark;

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> typeSerializerIn) throws Exception {
        this(operator, 1, 1, 0);
        this.config.setTypeSerializersIn(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, int maxParallelism, int parallelism, int subtaskIndex, TypeSerializer<IN> typeSerializerIn, OperatorID operatorID) throws Exception {
        this((StreamOperatorFactory<OUT>)SimpleOperatorFactory.of(operator), maxParallelism, parallelism, subtaskIndex, operatorID);
        this.config.setTypeSerializersIn(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> typeSerializerIn, MockEnvironment environment) throws Exception {
        this(operator, environment);
        this.config.setTypeSerializersIn(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator) throws Exception {
        this(operator, 1, 1, 0);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory) throws Exception {
        this(factory, 1, 1, 0);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, int maxParallelism, int parallelism, int subtaskIndex) throws Exception {
        this((StreamOperatorFactory<OUT>)SimpleOperatorFactory.of(operator), maxParallelism, parallelism, subtaskIndex);
    }

    public OneInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, int maxParallelism, int parallelism, int subtaskIndex) throws Exception {
        this(operatorFactory, maxParallelism, parallelism, subtaskIndex, new OperatorID());
    }

    public OneInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, int maxParallelism, int parallelism, int subtaskIndex, OperatorID operatorID) throws Exception {
        super(operatorFactory, maxParallelism, parallelism, subtaskIndex, operatorID);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, MockEnvironment environment) throws Exception {
        super(operator, environment);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory, TypeSerializer<IN> typeSerializerIn, MockEnvironment environment) throws Exception {
        this(factory, environment);
        this.config.setTypeSerializersIn(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory, MockEnvironment environment) throws Exception {
        super(factory, environment);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory, TypeSerializer<IN> typeSerializerIn) throws Exception {
        this(factory, 1, 1, 0);
        this.config.setTypeSerializersIn(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory, int maxParallelism, int parallelism, int subtaskIndex) throws Exception {
        this(factory, maxParallelism, parallelism, subtaskIndex, new OperatorID());
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperatorFactory<IN, OUT> factory, int maxParallelism, int parallelism, int subtaskIndex, OperatorID operatorID) throws Exception {
        super(factory, maxParallelism, parallelism, subtaskIndex, operatorID);
    }

    @Override
    public void setup(TypeSerializer<OUT> outputSerializer) {
        super.setup(outputSerializer);
        if (this.operator instanceof MultipleInputStreamOperator) {
            Preconditions.checkState((boolean)this.inputs.isEmpty());
            this.inputs.addAll(((MultipleInputStreamOperator)this.operator).getInputs());
        }
    }

    public OneInputStreamOperator<IN, OUT> getOneInputOperator() {
        return (OneInputStreamOperator)this.operator;
    }

    public void processElement(IN value, long timestamp) throws Exception {
        this.processElement(new StreamRecord(value, timestamp));
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        if (this.inputs.isEmpty()) {
            this.operator.setKeyContextElement1(element);
            this.getOneInputOperator().processElement(element);
        } else {
            Preconditions.checkState((this.inputs.size() == 1 ? 1 : 0) != 0);
            Input input = this.inputs.get(0);
            input.setKeyContextElement(element);
            input.processElement(element);
        }
    }

    public void processElements(Collection<StreamRecord<IN>> elements) throws Exception {
        for (StreamRecord<IN> element : elements) {
            this.processElement(element);
        }
    }

    public void processWatermark(long watermark) throws Exception {
        this.processWatermark(new Watermark(watermark));
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.currentWatermark = mark.getTimestamp();
        if (this.inputs.isEmpty()) {
            this.getOneInputOperator().processWatermark(mark);
        } else {
            Preconditions.checkState((this.inputs.size() == 1 ? 1 : 0) != 0);
            Input input = this.inputs.get(0);
            input.processWatermark(mark);
        }
    }

    public void endInput() throws Exception {
        if (this.operator instanceof BoundedOneInput) {
            ((BoundedOneInput)this.operator).endInput();
        }
    }

    public long getCurrentWatermark() {
        return this.currentWatermark;
    }
}

