/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;

public class MockStreamingRuntimeContext
extends StreamingRuntimeContext {
    private final boolean isCheckpointingEnabled;
    private final int numParallelSubtasks;
    private final int subtaskIndex;

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex) {
        this(isCheckpointingEnabled, numParallelSubtasks, subtaskIndex, null);
    }

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex, IOManager ioManager) {
        super((AbstractStreamOperator)new MockStreamOperator(), (Environment)new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).setIOManager(ioManager).build(), new HashMap());
        this.isCheckpointingEnabled = isCheckpointingEnabled;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
    }

    public MetricGroup getMetricGroup() {
        return new UnregisteredMetricsGroup();
    }

    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    private static class MockStreamOperator
    extends AbstractStreamOperator<Integer> {
        private static final long serialVersionUID = -1153976702711944427L;
        private transient TestProcessingTimeService testProcessingTimeService;

        private MockStreamOperator() {
        }

        public ExecutionConfig getExecutionConfig() {
            return new ExecutionConfig();
        }

        public OperatorID getOperatorID() {
            return new OperatorID();
        }

        public ProcessingTimeService getProcessingTimeService() {
            if (this.testProcessingTimeService == null) {
                this.testProcessingTimeService = new TestProcessingTimeService();
            }
            return this.testProcessingTimeService;
        }
    }
}

