/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.util.TestSequentialReadingStreamOperator;

public class MockStreamConfig
extends StreamConfig {
    public MockStreamConfig(Configuration configuration, int numberOfOutputs) {
        super(configuration);
        this.setChainStart();
        this.setOutputSelectors(Collections.emptyList());
        this.setNumberOfOutputs(numberOfOutputs);
        this.setTypeSerializerOut((TypeSerializer)new StringSerializer());
        this.setVertexID(0);
        this.setStreamOperator((StreamOperator)new TestSequentialReadingStreamOperator("test operator"));
        this.setOperatorID(new OperatorID());
        AbstractStreamOperator dummyOperator = new AbstractStreamOperator(){
            private static final long serialVersionUID = 1L;
        };
        StreamNode sourceVertex = new StreamNode(Integer.valueOf(0), null, null, (StreamOperator)dummyOperator, "source", new ArrayList(), SourceStreamTask.class);
        StreamNode targetVertex = new StreamNode(Integer.valueOf(1), null, null, (StreamOperator)dummyOperator, "target", new ArrayList(), SourceStreamTask.class);
        ArrayList<StreamEdge> outEdgesInOrder = new ArrayList<StreamEdge>(numberOfOutputs);
        for (int i = 0; i < numberOfOutputs; ++i) {
            outEdgesInOrder.add(new StreamEdge(sourceVertex, targetVertex, numberOfOutputs, new ArrayList(), (StreamPartitioner)new BroadcastPartitioner(), null));
        }
        this.setOutEdgesInOrder(outEdgesInOrder);
        this.setNonChainedOutputs(outEdgesInOrder);
    }
}

