/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.util.LatencyStats;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class LatencyStatsTest
extends TestLogger {
    private static final OperatorID OPERATOR_ID = new OperatorID();
    private static final OperatorID SOURCE_ID_1 = new OperatorID();
    private static final OperatorID SOURCE_ID_2 = new OperatorID();
    private static final int OPERATOR_SUBTASK_INDEX = 64;
    private static final String PARENT_GROUP_NAME = "parent";

    @Test
    public void testLatencyStatsSingle() {
        LatencyStatsTest.testLatencyStats(LatencyStats.Granularity.SINGLE, registrations -> {
            Assert.assertEquals((long)1L, (long)registrations.size());
            Tuple2 registration = (Tuple2)registrations.get(0);
            LatencyStatsTest.assertName((String)registration.f0);
            Assert.assertEquals((long)5L, (long)((Histogram)registration.f1).getCount());
        });
    }

    @Test
    public void testLatencyStatsOperator() {
        LatencyStatsTest.testLatencyStats(LatencyStats.Granularity.OPERATOR, registrations -> {
            Assert.assertEquals((long)2L, (long)registrations.size());
            Tuple2 registration = (Tuple2)registrations.get(0);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_1);
            Assert.assertEquals((long)3L, (long)((Histogram)registration.f1).getCount());
            registration = (Tuple2)registrations.get(1);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_2);
            Assert.assertEquals((long)2L, (long)((Histogram)registration.f1).getCount());
        });
    }

    @Test
    public void testLatencyStatsSubtask() {
        LatencyStatsTest.testLatencyStats(LatencyStats.Granularity.SUBTASK, registrations -> {
            Assert.assertEquals((long)4L, (long)registrations.size());
            Tuple2 registration = (Tuple2)registrations.get(0);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_1, 0);
            Assert.assertEquals((long)2L, (long)((Histogram)registration.f1).getCount());
            registration = (Tuple2)registrations.get(1);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_1, 1);
            Assert.assertEquals((long)1L, (long)((Histogram)registration.f1).getCount());
            registration = (Tuple2)registrations.get(2);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_2, 2);
            Assert.assertEquals((long)1L, (long)((Histogram)registration.f1).getCount());
            registration = (Tuple2)registrations.get(3);
            LatencyStatsTest.assertName((String)registration.f0, SOURCE_ID_2, 3);
            Assert.assertEquals((long)1L, (long)((Histogram)registration.f1).getCount());
        });
    }

    private static void testLatencyStats(LatencyStats.Granularity granularity, Consumer<List<Tuple2<String, Histogram>>> verifier) {
        OperatorMetricGroup dummyGroup = UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup();
        TestMetricRegistry registry = new TestMetricRegistry();
        GenericMetricGroup parentGroup = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)dummyGroup, PARENT_GROUP_NAME);
        LatencyStats latencyStats = new LatencyStats((MetricGroup)parentGroup, ((Integer)MetricOptions.LATENCY_HISTORY_SIZE.defaultValue()).intValue(), 64, OPERATOR_ID, granularity);
        latencyStats.reportLatency(new LatencyMarker(0L, SOURCE_ID_1, 0));
        latencyStats.reportLatency(new LatencyMarker(0L, SOURCE_ID_1, 0));
        latencyStats.reportLatency(new LatencyMarker(0L, SOURCE_ID_1, 1));
        latencyStats.reportLatency(new LatencyMarker(0L, SOURCE_ID_2, 2));
        latencyStats.reportLatency(new LatencyMarker(0L, SOURCE_ID_2, 3));
        verifier.accept(registry.latencyHistograms);
    }

    private static String sanitizeName(String registrationName) {
        return registrationName.substring(registrationName.lastIndexOf(PARENT_GROUP_NAME) + PARENT_GROUP_NAME.length() + 1);
    }

    private static void assertName(String registrationName) {
        String sanitizedName = LatencyStatsTest.sanitizeName(registrationName);
        Assert.assertEquals((Object)("operator_id." + OPERATOR_ID + ".operator_subtask_index." + 64 + ".latency"), (Object)sanitizedName);
    }

    private static void assertName(String registrationName, OperatorID sourceId) {
        String sanitizedName = LatencyStatsTest.sanitizeName(registrationName);
        Assert.assertEquals((Object)("source_id." + sourceId + ".operator_id." + OPERATOR_ID + ".operator_subtask_index." + 64 + ".latency"), (Object)sanitizedName);
    }

    private static void assertName(String registrationName, OperatorID sourceId, int sourceIndex) {
        String sanitizedName = LatencyStatsTest.sanitizeName(registrationName);
        Assert.assertEquals((Object)("source_id." + sourceId + ".source_subtask_index." + sourceIndex + ".operator_id." + OPERATOR_ID + ".operator_subtask_index." + 64 + ".latency"), (Object)sanitizedName);
    }

    private static class TestMetricRegistry
    implements MetricRegistry {
        private final List<Tuple2<String, Histogram>> latencyHistograms = new ArrayList<Tuple2<String, Histogram>>(4);

        private TestMetricRegistry() {
        }

        public void register(Metric metric, String metricName, AbstractMetricGroup group) {
            if (metric instanceof Histogram) {
                this.latencyHistograms.add((Tuple2<String, Histogram>)Tuple2.of((Object)group.getMetricIdentifier(metricName), (Object)((Histogram)metric)));
            }
        }

        public char getDelimiter() {
            return '.';
        }

        public int getNumberReporters() {
            return 0;
        }

        public void unregister(Metric metric, String metricName, AbstractMetricGroup group) {
        }

        public ScopeFormats getScopeFormats() {
            return null;
        }
    }
}

