/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Queue;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.partition.consumer.StreamTestSingleInputGate;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.taskmanager.TestCheckpointResponder;
import org.apache.flink.streaming.runtime.tasks.StreamMockEnvironment;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class StreamTaskMailboxTestHarness<OUT>
implements AutoCloseable {
    protected final StreamTask<OUT, ?> streamTask;
    protected final StreamMockEnvironment streamMockEnvironment;
    protected final TestTaskStateManager taskStateManager;
    protected final Queue<Object> outputList;
    protected final StreamTestSingleInputGate[] inputGates;
    protected final boolean[] inputGateEnded;
    private boolean autoProcess = true;

    StreamTaskMailboxTestHarness(StreamTask<OUT, ?> streamTask, Queue<Object> outputList, StreamTestSingleInputGate[] inputGates, StreamMockEnvironment streamMockEnvironment) {
        this.streamTask = (StreamTask)Preconditions.checkNotNull(streamTask);
        this.taskStateManager = (TestTaskStateManager)streamMockEnvironment.getTaskStateManager();
        this.inputGates = (StreamTestSingleInputGate[])Preconditions.checkNotNull((Object)inputGates);
        this.outputList = (Queue)Preconditions.checkNotNull(outputList);
        this.streamMockEnvironment = (StreamMockEnvironment)Preconditions.checkNotNull((Object)streamMockEnvironment);
        this.inputGateEnded = new boolean[inputGates.length];
    }

    public TestTaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public StreamTask<OUT, ?> getStreamTask() {
        return this.streamTask;
    }

    public Queue<Object> getOutput() {
        return this.outputList;
    }

    public void processElement(Object element) throws Exception {
        this.processElement(element, 0);
    }

    public void processElement(Object element, int inputGate) throws Exception {
        this.processElement(element, inputGate, 0);
    }

    public void processElement(Object element, int inputGate, int channel) throws Exception {
        this.inputGates[inputGate].sendElement(element, channel);
        this.maybeProcess();
    }

    public void processEvent(AbstractEvent event) throws Exception {
        this.processEvent(event, 0);
    }

    public void processEvent(AbstractEvent event, int inputGate) throws Exception {
        this.processEvent(event, inputGate, 0);
    }

    public void processEvent(AbstractEvent event, int inputGate, int channel) throws Exception {
        this.inputGates[inputGate].sendEvent(event, channel);
        this.maybeProcess();
    }

    private void maybeProcess() throws Exception {
        if (this.autoProcess) {
            this.processWhileAvailable();
        }
    }

    public void processWhileAvailable() throws Exception {
        while (this.processIfAvailable()) {
        }
    }

    public boolean processIfAvailable() throws Exception {
        if (this.streamTask.inputProcessor.isAvailable() && this.streamTask.mailboxProcessor.isMailboxLoopRunning()) {
            this.streamTask.runMailboxStep();
            return true;
        }
        return false;
    }

    public void processSingleStep() throws Exception {
        if (this.streamTask.mailboxProcessor.isMailboxLoopRunning()) {
            this.streamTask.runMailboxStep();
        }
    }

    public void endInput() {
        for (int i = 0; i < this.inputGates.length; ++i) {
            this.endInput(i);
        }
    }

    public void endInput(int inputIndex) {
        if (!this.inputGateEnded[inputIndex]) {
            this.inputGates[inputIndex].endInput();
            this.inputGateEnded[inputIndex] = true;
        }
    }

    public void waitForTaskCompletion() throws Exception {
        this.endInput();
        while (this.streamTask.isMailboxLoopRunning()) {
            this.streamTask.runMailboxStep();
        }
    }

    public void finishProcessing() throws Exception {
        this.streamTask.afterInvoke();
        this.streamTask.cleanUpInvoke();
    }

    @Override
    public void close() throws Exception {
        if (this.streamTask.isRunning()) {
            this.streamTask.cancel();
            this.finishProcessing();
        }
        this.streamMockEnvironment.getIOManager().close();
        MemoryManager memMan = this.streamMockEnvironment.getMemoryManager();
        if (memMan != null) {
            Assert.assertTrue((String)"Memory Manager managed memory was not completely freed.", (boolean)memMan.verifyEmpty());
            memMan.shutdown();
        }
    }

    public void setAutoProcess(boolean autoProcess) {
        this.autoProcess = autoProcess;
    }

    public TestCheckpointResponder getCheckpointResponder() {
        return (TestCheckpointResponder)this.taskStateManager.getCheckpointResponder();
    }
}

