/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.Preconditions;

public class StreamConfigChainer<OWNER> {
    private final OWNER owner;
    private final StreamConfig headConfig;
    private final Map<Integer, StreamConfig> chainedConfigs = new HashMap<Integer, StreamConfig>();
    private StreamConfig tailConfig;
    private int chainIndex = 0;

    StreamConfigChainer(OperatorID headOperatorID, StreamConfig headConfig, OWNER owner) {
        this.owner = Preconditions.checkNotNull(owner);
        this.headConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.tailConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.head(headOperatorID);
    }

    private void head(OperatorID headOperatorID) {
        this.headConfig.setOperatorID(headOperatorID);
        this.headConfig.setChainStart();
        this.headConfig.setChainIndex(this.chainIndex);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer, boolean createKeyedStateBackend) {
        return this.chain(operatorID, operator, typeSerializer, typeSerializer, createKeyedStateBackend);
    }

    public <T> StreamConfigChainer<OWNER> chain(OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer) {
        return this.chain(new OperatorID(), operator, typeSerializer);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer) {
        return this.chain(operatorID, operator, typeSerializer, typeSerializer, false);
    }

    public <T> StreamConfigChainer<OWNER> chain(OneInputStreamOperatorFactory<T, T> operatorFactory, TypeSerializer<T> typeSerializer) {
        return this.chain(new OperatorID(), operatorFactory, typeSerializer);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperatorFactory<T, T> operatorFactory, TypeSerializer<T> typeSerializer) {
        return this.chain(operatorID, (StreamOperatorFactory)operatorFactory, (TypeSerializer)typeSerializer, (TypeSerializer)typeSerializer, false);
    }

    private <IN, OUT> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> inputSerializer, TypeSerializer<OUT> outputSerializer, boolean createKeyedStateBackend) {
        return this.chain(operatorID, (StreamOperatorFactory<OUT>)SimpleOperatorFactory.of(operator), inputSerializer, outputSerializer, createKeyedStateBackend);
    }

    public <IN, OUT> StreamConfigChainer<OWNER> chain(OperatorID operatorID, StreamOperatorFactory<OUT> operatorFactory, TypeSerializer<IN> inputSerializer, TypeSerializer<OUT> outputSerializer, boolean createKeyedStateBackend) {
        ++this.chainIndex;
        this.tailConfig.setChainedOutputs(Collections.singletonList(new StreamEdge(new StreamNode(Integer.valueOf(this.tailConfig.getChainIndex()), null, null, (StreamOperator)null, null, null, null), new StreamNode(Integer.valueOf(this.chainIndex), null, null, (StreamOperator)null, null, null, null), 0, Collections.emptyList(), null, null)));
        this.tailConfig = new StreamConfig(new Configuration());
        this.tailConfig.setStreamOperatorFactory((StreamOperatorFactory)Preconditions.checkNotNull(operatorFactory));
        this.tailConfig.setOperatorID((OperatorID)Preconditions.checkNotNull((Object)operatorID));
        this.tailConfig.setTypeSerializersIn(new TypeSerializer[]{inputSerializer});
        this.tailConfig.setTypeSerializerOut(outputSerializer);
        if (createKeyedStateBackend) {
            this.tailConfig.setStateKeySerializer(inputSerializer);
        }
        this.tailConfig.setChainIndex(this.chainIndex);
        this.chainedConfigs.put(this.chainIndex, this.tailConfig);
        return this;
    }

    public OWNER finish() {
        LinkedList<StreamEdge> outEdgesInOrder = new LinkedList<StreamEdge>();
        outEdgesInOrder.add(new StreamEdge(new StreamNode(Integer.valueOf(this.chainIndex), null, null, (StreamOperator)null, null, null, null), new StreamNode(Integer.valueOf(this.chainIndex), null, null, (StreamOperator)null, null, null, null), 0, Collections.emptyList(), (StreamPartitioner)new BroadcastPartitioner(), null));
        this.tailConfig.setChainEnd();
        this.tailConfig.setOutputSelectors(Collections.emptyList());
        this.tailConfig.setNumberOfOutputs(1);
        this.tailConfig.setOutEdgesInOrder(outEdgesInOrder);
        this.tailConfig.setNonChainedOutputs(outEdgesInOrder);
        this.headConfig.setTransitiveChainedTaskConfigs(this.chainedConfigs);
        this.headConfig.setOutEdgesInOrder(outEdgesInOrder);
        return this.owner;
    }
}

