/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.runtime.tasks.AsyncCheckpointRunnable;
import org.apache.flink.streaming.runtime.tasks.ExceptionallyDoneFuture;
import org.apache.flink.streaming.runtime.tasks.StreamMockEnvironment;
import org.junit.Assert;
import org.junit.Test;

public class AsyncCheckpointRunnableTest {
    @Test
    public void testAsyncCheckpointException() {
        HashMap<OperatorID, OperatorSnapshotFutures> snapshotsInProgress = new HashMap<OperatorID, OperatorSnapshotFutures>();
        snapshotsInProgress.put(new OperatorID(), new OperatorSnapshotFutures(ExceptionallyDoneFuture.of(new RuntimeException("Async Checkpoint Exception")), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (Future)DoneFuture.of((Object)SnapshotResult.empty()), (Future)DoneFuture.of((Object)SnapshotResult.empty())));
        TestEnvironment environment = new TestEnvironment();
        AsyncCheckpointRunnable runnable = new AsyncCheckpointRunnable(snapshotsInProgress, new CheckpointMetaData(1L, 1L), new CheckpointMetrics(), 1L, "Task Name", r -> {}, r -> {}, (Environment)environment, (msg, ex) -> {});
        runnable.run();
        Assert.assertTrue((boolean)(environment.getCause() instanceof CheckpointException));
        Assert.assertSame((Object)((CheckpointException)environment.getCause()).getCheckpointFailureReason(), (Object)CheckpointFailureReason.CHECKPOINT_ASYNC_EXCEPTION);
    }

    private static class TestEnvironment
    extends StreamMockEnvironment {
        Throwable cause = null;

        TestEnvironment() {
            this(new Configuration(), new Configuration(), new ExecutionConfig(), 1L, new MockInputSplitProvider(), 1, (TaskStateManager)new TestTaskStateManager());
        }

        TestEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
            super(jobConfig, taskConfig, executionConfig, memorySize, inputSplitProvider, bufferSize, taskStateManager);
        }

        @Override
        public void declineCheckpoint(long checkpointId, Throwable cause) {
            this.cause = cause;
        }

        Throwable getCause() {
            return this.cause;
        }
    }
}

