/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.io.IOException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateFactory;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;

public class SingleInputGateBenchmarkFactory
extends SingleInputGateFactory {
    public SingleInputGateBenchmarkFactory(ResourceID taskExecutorResourceId, NettyShuffleEnvironmentConfiguration networkConfig, ConnectionManager connectionManager, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, NetworkBufferPool networkBufferPool) {
        super(taskExecutorResourceId, networkConfig, connectionManager, partitionManager, taskEventPublisher, networkBufferPool);
    }

    protected InputChannel createKnownInputChannel(SingleInputGate inputGate, int index, NettyShuffleDescriptor inputChannelDescriptor, SingleInputGateFactory.ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        ResultPartitionID partitionId = inputChannelDescriptor.getResultPartitionID();
        if (inputChannelDescriptor.isLocalTo(this.taskExecutorResourceId)) {
            return new TestLocalInputChannel(inputGate, index, partitionId, this.partitionManager, this.taskEventPublisher, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, metrics);
        }
        return new TestRemoteInputChannel(inputGate, index, partitionId, inputChannelDescriptor.getConnectionId(), this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, metrics);
    }

    static class TestRemoteInputChannel
    extends RemoteInputChannel {
        private final ResultPartitionID newPartitionID = new ResultPartitionID();

        public TestRemoteInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ConnectionID connectionId, ConnectionManager connectionManager, int initialBackOff, int maxBackoff, InputChannelMetrics metrics) {
            super(inputGate, channelIndex, partitionId, connectionId, connectionManager, initialBackOff, maxBackoff, metrics.getNumBytesInRemoteCounter(), metrics.getNumBuffersInRemoteCounter());
        }

        public void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
            super.requestSubpartition(this.getChannelIndex());
        }

        public ResultPartitionID getPartitionId() {
            return this.newPartitionID;
        }
    }

    static class TestLocalInputChannel
    extends LocalInputChannel {
        private final ResultPartitionID newPartitionID = new ResultPartitionID();

        public TestLocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, int initialBackoff, int maxBackoff, InputChannelMetrics metrics) {
            super(inputGate, channelIndex, partitionId, partitionManager, taskEventPublisher, initialBackoff, maxBackoff, metrics.getNumBytesInLocalCounter(), metrics.getNumBuffersInLocalCounter());
        }

        public void requestSubpartition(int subpartitionIndex) throws IOException {
            super.requestSubpartition(this.getChannelIndex());
        }

        public ResultPartitionID getPartitionId() {
            return this.newPartitionID;
        }
    }
}

