/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

public class MockInputGate
extends InputGate {
    private final int numberOfChannels;
    private final Queue<BufferOrEvent> bufferOrEvents;
    private final boolean[] closed;
    private final boolean finishAfterLastBuffer;
    private ArrayList<Integer> lastUnblockedChannels = new ArrayList();

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents) {
        this(numberOfChannels, bufferOrEvents, true);
    }

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents, boolean finishAfterLastBuffer) {
        this.numberOfChannels = numberOfChannels;
        this.bufferOrEvents = new ArrayDeque<BufferOrEvent>(bufferOrEvents);
        this.closed = new boolean[numberOfChannels];
        this.finishAfterLastBuffer = finishAfterLastBuffer;
        this.availabilityHelper.resetAvailable();
    }

    public void setup() {
    }

    public CompletableFuture<?> readRecoveredState(ExecutorService executor, ChannelStateReader reader) {
        return CompletableFuture.completedFuture(null);
    }

    public void requestPartitions() {
    }

    public int getNumberOfInputChannels() {
        return this.numberOfChannels;
    }

    public InputChannel getChannel(int channelIndex) {
        throw new UnsupportedOperationException();
    }

    public List<InputChannelInfo> getChannelInfos() {
        return IntStream.range(0, this.numberOfChannels).mapToObj(channelIndex -> new InputChannelInfo(0, channelIndex)).collect(Collectors.toList());
    }

    public boolean isFinished() {
        return this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty();
    }

    public Optional<BufferOrEvent> getNext() {
        BufferOrEvent next = this.bufferOrEvents.poll();
        if (!this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty()) {
            this.availabilityHelper.resetUnavailable();
        }
        if (next == null) {
            return Optional.empty();
        }
        int channelIdx = next.getChannelInfo().getInputChannelIdx();
        if (this.closed[channelIdx]) {
            throw new RuntimeException("Inconsistent: Channel " + channelIdx + " has data even though it is already closed.");
        }
        if (next.isEvent() && next.getEvent() instanceof EndOfPartitionEvent) {
            this.closed[channelIdx] = true;
        }
        return Optional.of(next);
    }

    public Optional<BufferOrEvent> pollNext() {
        return this.getNext();
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void resumeConsumption(int channelIndex) {
        this.lastUnblockedChannels.add(channelIndex);
    }

    public ArrayList<Integer> getAndResetLastUnblockedChannels() {
        ArrayList<Integer> unblockedChannels = this.lastUnblockedChannels;
        this.lastUnblockedChannels = new ArrayList();
        return unblockedChannels;
    }

    public void close() {
    }

    public void registerBufferReceivedListener(BufferReceivedListener listener) {
    }
}

