/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.MockChannelStateWriter;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.InputProcessorUtil;
import org.apache.flink.streaming.runtime.io.MockIndexedInputGate;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.TestSubtaskCheckpointCoordinator;
import org.apache.flink.streaming.util.MockStreamTask;
import org.apache.flink.streaming.util.MockStreamTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class InputProcessorUtilTest {
    @Test
    public void testCreateCheckpointedMultipleInputGate() throws Exception {
        try (CloseableRegistry registry = new CloseableRegistry();){
            CheckpointedInputGate[] checkpointedMultipleInputGate;
            MockEnvironment environment = new MockEnvironmentBuilder().build();
            MockStreamTask streamTask = new MockStreamTaskBuilder((Environment)environment).build();
            StreamConfig streamConfig = new StreamConfig(environment.getJobConfiguration());
            streamConfig.setCheckpointMode(CheckpointingMode.EXACTLY_ONCE);
            streamConfig.setUnalignedCheckpointsEnabled(true);
            List[] inputGates = new List[]{Collections.singletonList(new MockIndexedInputGate(1, 4)), Collections.singletonList(new MockIndexedInputGate(0, 2))};
            for (CheckpointedInputGate checkpointedInputGate : checkpointedMultipleInputGate = InputProcessorUtil.createCheckpointedMultipleInputGate((AbstractInvokable)streamTask, (StreamConfig)streamConfig, (SubtaskCheckpointCoordinator)new TestSubtaskCheckpointCoordinator((ChannelStateWriter)new MockChannelStateWriter()), (TaskIOMetricGroup)environment.getMetricGroup().getIOMetricGroup(), (String)streamTask.getName(), (List[])inputGates)) {
                registry.registerCloseable((Closeable)checkpointedInputGate);
            }
            CheckpointBarrierHandler barrierHandler = checkpointedMultipleInputGate[0].getCheckpointBarrierHandler();
            Assert.assertTrue((boolean)barrierHandler.getBufferReceivedListener().isPresent());
            BufferReceivedListener bufferReceivedListener = (BufferReceivedListener)barrierHandler.getBufferReceivedListener().get();
            List allInputGates = Arrays.stream(inputGates).flatMap(gates -> gates.stream()).collect(Collectors.toList());
            for (IndexedInputGate inputGate : allInputGates) {
                for (int channelId = 0; channelId < inputGate.getNumberOfInputChannels(); ++channelId) {
                    bufferReceivedListener.notifyBarrierReceived(new CheckpointBarrier(1L, 42L, CheckpointOptions.forCheckpointWithDefaultLocation((boolean)true, (boolean)true)), new InputChannelInfo(inputGate.getGateIndex(), channelId));
                }
            }
            Assert.assertTrue((boolean)barrierHandler.getAllBarriersReceivedFuture(1L).isDone());
        }
    }
}

