/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.environment;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.environment.TestingJobClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class ExecutorDiscoveryAndJobClientTest {
    private static final String EXEC_NAME = "test-executor";

    @Test
    public void jobClientGetJobExecutionResultShouldBeCalledOnAttachedExecution() throws Exception {
        this.testHelper(true);
    }

    @Test
    public void jobClientGetJobExecutionResultShouldBeCalledOnDetachedExecution() throws Exception {
        this.testHelper(false);
    }

    private void testHelper(boolean attached) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(DeploymentOptions.TARGET, (Object)EXEC_NAME);
        configuration.set(DeploymentOptions.ATTACHED, (Object)attached);
        JobExecutionResult result = this.executeTestJobBasedOnConfig(configuration);
        MatcherAssert.assertThat((Object)result.isJobExecutionResult(), (Matcher)Is.is((Object)attached));
    }

    private JobExecutionResult executeTestJobBasedOnConfig(Configuration configuration) throws Exception {
        StreamExecutionEnvironment env = new StreamExecutionEnvironment(configuration);
        env.fromCollection(Collections.singletonList(42)).addSink((SinkFunction)new DiscardingSink());
        return env.execute();
    }

    public static class IDReportingExecutorFactory
    implements PipelineExecutorFactory {
        public String getName() {
            return ExecutorDiscoveryAndJobClientTest.EXEC_NAME;
        }

        public boolean isCompatibleWith(Configuration configuration) {
            return ExecutorDiscoveryAndJobClientTest.EXEC_NAME.equals(configuration.get(DeploymentOptions.TARGET));
        }

        public PipelineExecutor getExecutor(Configuration configuration) {
            return (pipeline, executionConfig) -> CompletableFuture.completedFuture(new TestingJobClient());
        }
    }
}

