/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.api.connector.source.mocks.MockSourceSplitSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.coordination.MockOperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;

public class TestingSourceOperator<T>
extends SourceOperator<T, MockSourceSplit> {
    private static final long serialVersionUID = 1L;
    private final int subtaskIndex;
    private final int parallelism;

    public TestingSourceOperator(SourceReader<T, MockSourceSplit> reader, WatermarkStrategy<T> watermarkStrategy, ProcessingTimeService timeService) {
        this(reader, watermarkStrategy, timeService, (OperatorEventGateway)new MockOperatorEventGateway(), 1, 5);
    }

    public TestingSourceOperator(SourceReader<T, MockSourceSplit> reader, OperatorEventGateway eventGateway, int subtaskIndex) {
        this(reader, WatermarkStrategy.noWatermarks(), (ProcessingTimeService)new TestProcessingTimeService(), eventGateway, subtaskIndex, 5);
    }

    public TestingSourceOperator(SourceReader<T, MockSourceSplit> reader, WatermarkStrategy<T> watermarkStrategy, ProcessingTimeService timeService, OperatorEventGateway eventGateway, int subtaskIndex, int parallelism) {
        super(context -> reader, eventGateway, (SimpleVersionedSerializer)new MockSourceSplitSerializer(), watermarkStrategy, timeService, new Configuration(), "localhost");
        this.subtaskIndex = subtaskIndex;
        this.parallelism = parallelism;
        this.metrics = UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup();
        try {
            this.initReader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StreamingRuntimeContext getRuntimeContext() {
        return new MockStreamingRuntimeContext(false, this.parallelism, this.subtaskIndex);
    }

    public ExecutionConfig getExecutionConfig() {
        ExecutionConfig cfg = new ExecutionConfig();
        cfg.setAutoWatermarkInterval(100L);
        return cfg;
    }
}

