/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.TimerSerializer;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

public class TimerSerializerTest
extends SerializerTestBase<TimerHeapInternalTimer<Long, TimeWindow>> {
    private static final TypeSerializer<Long> KEY_SERIALIZER = LongSerializer.INSTANCE;
    private static final TypeSerializer<TimeWindow> NAMESPACE_SERIALIZER = new TimeWindow.Serializer();

    protected TypeSerializer<TimerHeapInternalTimer<Long, TimeWindow>> createSerializer() {
        return new TimerSerializer(KEY_SERIALIZER, NAMESPACE_SERIALIZER);
    }

    protected int getLength() {
        return 8 + KEY_SERIALIZER.getLength() + NAMESPACE_SERIALIZER.getLength();
    }

    protected Class<TimerHeapInternalTimer<Long, TimeWindow>> getTypeClass() {
        return TimerHeapInternalTimer.class;
    }

    protected TimerHeapInternalTimer<Long, TimeWindow>[] getTestData() {
        return new TimerHeapInternalTimer[]{new TimerHeapInternalTimer(42L, (Object)4711L, (Object)new TimeWindow(1000L, 2000L)), new TimerHeapInternalTimer(0L, (Object)0L, (Object)new TimeWindow(0L, 0L)), new TimerHeapInternalTimer(1L, (Object)-1L, (Object)new TimeWindow(1L, -1L)), new TimerHeapInternalTimer(-1L, (Object)1L, (Object)new TimeWindow(-1L, 1L)), new TimerHeapInternalTimer(Long.MAX_VALUE, (Object)Long.MIN_VALUE, (Object)new TimeWindow(Long.MAX_VALUE, Long.MIN_VALUE)), new TimerHeapInternalTimer(Long.MIN_VALUE, (Object)Long.MAX_VALUE, (Object)new TimeWindow(Long.MIN_VALUE, Long.MAX_VALUE))};
    }
}

