/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.datastream.ConnectedStreams;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.IterativeStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.util.EvenOddOutputSelector;
import org.apache.flink.streaming.util.NoOpIntMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public class StreamGraphGeneratorTest
extends TestLogger {
    @Test
    public void generatorForwardsSavepointRestoreSettings() {
        StreamGraphGenerator streamGraphGenerator = new StreamGraphGenerator(Collections.emptyList(), new ExecutionConfig(), new CheckpointConfig());
        streamGraphGenerator.setSavepointRestoreSettings(SavepointRestoreSettings.forPath((String)"hello"));
        StreamGraph streamGraph = streamGraphGenerator.generate();
        Assert.assertThat((Object)streamGraph.getSavepointRestoreSettings().getRestorePath(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testBufferTimeout() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setBufferTimeout(77L);
        env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5}).map((MapFunction & Serializable)value -> value).setBufferTimeout(-1L).name("A").map((MapFunction & Serializable)value -> value).setBufferTimeout(0L).name("B").map((MapFunction & Serializable)value -> value).setBufferTimeout(12L).name("C").map((MapFunction & Serializable)value -> value).name("D");
        StreamGraph sg = env.getStreamGraph();
        block12: for (StreamNode node : sg.getStreamNodes()) {
            switch (node.getOperatorName()) {
                case "A": {
                    Assert.assertEquals((long)77L, (long)node.getBufferTimeout());
                    continue block12;
                }
                case "B": {
                    Assert.assertEquals((long)0L, (long)node.getBufferTimeout());
                    continue block12;
                }
                case "C": {
                    Assert.assertEquals((long)12L, (long)node.getBufferTimeout());
                    continue block12;
                }
                case "D": {
                    Assert.assertEquals((long)77L, (long)node.getBufferTimeout());
                    continue block12;
                }
            }
            Assert.assertTrue((boolean)(node.getOperator() instanceof StreamSource));
        }
    }

    @Test
    public void testVirtualTransformations() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 10});
        SingleOutputStreamOperator rebalanceMap = source.rebalance().map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator broadcastMap = rebalanceMap.forward().global().broadcast().map((MapFunction)new NoOpIntMap());
        broadcastMap.addSink((SinkFunction)new DiscardingSink());
        EvenOddOutputSelector selector1 = new EvenOddOutputSelector();
        EvenOddOutputSelector selector2 = new EvenOddOutputSelector();
        EvenOddOutputSelector selector3 = new EvenOddOutputSelector();
        SingleOutputStreamOperator map1Operator = rebalanceMap.map((MapFunction)new NoOpIntMap());
        DataStream map1 = map1Operator.broadcast().split((OutputSelector)selector1).select(new String[]{"even"});
        SingleOutputStreamOperator map2Operator = rebalanceMap.map((MapFunction)new NoOpIntMap());
        DataStream map2 = map2Operator.split((OutputSelector)selector2).select(new String[]{"odd"}).global();
        SingleOutputStreamOperator map3Operator = rebalanceMap.map((MapFunction)new NoOpIntMap());
        DataStream map3 = map3Operator.global().split((OutputSelector)selector3).select(new String[]{"even"}).shuffle();
        SingleOutputStreamOperator unionedMap = map1.union(new DataStream[]{map2}).union(new DataStream[]{map3}).map((MapFunction)new NoOpIntMap());
        unionedMap.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(rebalanceMap.getId())).getInEdges().get(0)).getPartitioner() instanceof RebalancePartitioner));
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(broadcastMap.getId())).getInEdges().get(0)).getPartitioner() instanceof BroadcastPartitioner));
        Assert.assertEquals((long)rebalanceMap.getId(), (long)graph.getSourceVertex((StreamEdge)graph.getStreamNode(Integer.valueOf(broadcastMap.getId())).getInEdges().get(0)).getId());
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map1Operator.getId())).getOutEdges().get(0)).getPartitioner() instanceof BroadcastPartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map1Operator.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("even"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map1Operator.getId())).getOutputSelectors().contains(selector1));
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map2Operator.getId())).getOutEdges().get(0)).getPartitioner() instanceof GlobalPartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map2Operator.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("odd"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map2Operator.getId())).getOutputSelectors().contains(selector2));
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map3Operator.getId())).getOutEdges().get(0)).getPartitioner() instanceof ShufflePartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map3Operator.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("even"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map3Operator.getId())).getOutputSelectors().contains(selector3));
    }

    @Test
    public void testVirtualTransformations2() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 10});
        SingleOutputStreamOperator rebalanceMap = source.rebalance().map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator map1 = rebalanceMap.map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator map2 = rebalanceMap.map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator map3 = rebalanceMap.map((MapFunction)new NoOpIntMap());
        EvenOddOutputSelector selector = new EvenOddOutputSelector();
        SingleOutputStreamOperator unionedMap = map1.union(new DataStream[]{map2}).union(new DataStream[]{map3}).broadcast().split((OutputSelector)selector).select(new String[]{"foo"}).map((MapFunction)new NoOpIntMap());
        unionedMap.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map1.getId())).getOutEdges().get(0)).getPartitioner() instanceof BroadcastPartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map1.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("foo"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map1.getId())).getOutputSelectors().contains(selector));
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map2.getId())).getOutEdges().get(0)).getPartitioner() instanceof BroadcastPartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map2.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("foo"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map2.getId())).getOutputSelectors().contains(selector));
        Assert.assertTrue((boolean)(((StreamEdge)graph.getStreamNode(Integer.valueOf(map3.getId())).getOutEdges().get(0)).getPartitioner() instanceof BroadcastPartitioner));
        Assert.assertTrue((boolean)((String)((StreamEdge)graph.getStreamNode(Integer.valueOf(map3.getId())).getOutEdges().get(0)).getSelectedNames().get(0)).equals("foo"));
        Assert.assertTrue((boolean)graph.getStreamNode(Integer.valueOf(map3.getId())).getOutputSelectors().contains(selector));
    }

    @Test
    public void testOutputTypeConfigurationWithOneInputTransformation() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 10});
        OutputTypeConfigurableOperationWithOneInput outputTypeConfigurableOperation = new OutputTypeConfigurableOperationWithOneInput();
        SingleOutputStreamOperator result = source.transform("Single input and output type configurable operation", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO, (OneInputStreamOperator)outputTypeConfigurableOperation);
        result.addSink((SinkFunction)new DiscardingSink());
        env.getStreamGraph();
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, outputTypeConfigurableOperation.getTypeInformation());
    }

    @Test
    public void testOutputTypeConfigurationWithTwoInputTransformation() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source1 = env.fromElements((Object[])new Integer[]{1, 10});
        DataStreamSource source2 = env.fromElements((Object[])new Integer[]{2, 11});
        ConnectedStreams connectedSource = source1.connect((DataStream)source2);
        OutputTypeConfigurableOperationWithTwoInputs outputTypeConfigurableOperation = new OutputTypeConfigurableOperationWithTwoInputs();
        SingleOutputStreamOperator result = connectedSource.transform("Two input and output type configurable operation", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO, (TwoInputStreamOperator)outputTypeConfigurableOperation);
        result.addSink((SinkFunction)new DiscardingSink());
        env.getStreamGraph();
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, outputTypeConfigurableOperation.getTypeInformation());
    }

    @Test
    public void testMultipleInputTransformation() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source1 = env.fromElements((Object[])new Integer[]{1, 10});
        DataStreamSource source2 = env.fromElements((Object[])new Long[]{2L, 11L});
        DataStreamSource source3 = env.fromElements((Object[])new String[]{"42", "44"});
        MultipleInputTransformation transform = new MultipleInputTransformation("My Operator", (StreamOperatorFactory)new MultipleInputOperatorFactory(), (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, 3);
        env.addOperator((Transformation)transform.addInput(source1.getTransformation()).addInput(source2.getTransformation()).addInput(source3.getTransformation()));
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((long)4L, (long)streamGraph.getStreamNodes().size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source1.getId(), transform.getId()).size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source2.getId(), transform.getId()).size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source3.getId(), transform.getId()).size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source1.getId()).size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source2.getId()).size());
        Assert.assertEquals((long)1L, (long)streamGraph.getStreamEdges(source3.getId()).size());
        Assert.assertEquals((long)0L, (long)streamGraph.getStreamEdges(transform.getId()).size());
    }

    @Test
    public void testSetupOfKeyGroupPartitioner() {
        int maxParallelism = 42;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setMaxParallelism(maxParallelism);
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2, 3});
        SingleOutputStreamOperator keyedResult = source.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap());
        keyedResult.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        StreamNode keyedResultNode = graph.getStreamNode(Integer.valueOf(keyedResult.getId()));
        StreamPartitioner streamPartitioner = ((StreamEdge)keyedResultNode.getInEdges().get(0)).getPartitioner();
    }

    @Test
    public void testMaxParallelismForwarding() {
        int globalMaxParallelism = 42;
        int keyedResult2MaxParallelism = 17;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setMaxParallelism(globalMaxParallelism);
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2, 3});
        SingleOutputStreamOperator keyedResult1 = source.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator keyedResult2 = keyedResult1.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap()).setMaxParallelism(keyedResult2MaxParallelism);
        keyedResult2.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        StreamNode keyedResult1Node = graph.getStreamNode(Integer.valueOf(keyedResult1.getId()));
        StreamNode keyedResult2Node = graph.getStreamNode(Integer.valueOf(keyedResult2.getId()));
        Assert.assertEquals((long)globalMaxParallelism, (long)keyedResult1Node.getMaxParallelism());
        Assert.assertEquals((long)keyedResult2MaxParallelism, (long)keyedResult2Node.getMaxParallelism());
    }

    @Test
    public void testAutoMaxParallelism() {
        int globalParallelism = 42;
        int mapParallelism = 17;
        int maxParallelism = 21;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(globalParallelism);
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2, 3});
        SingleOutputStreamOperator keyedResult1 = source.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap());
        SingleOutputStreamOperator keyedResult2 = keyedResult1.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap()).setParallelism(mapParallelism);
        SingleOutputStreamOperator keyedResult3 = keyedResult2.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap()).setMaxParallelism(maxParallelism);
        SingleOutputStreamOperator keyedResult4 = keyedResult3.keyBy((KeySelector & Serializable)value -> value).map((MapFunction)new NoOpIntMap()).setMaxParallelism(maxParallelism).setParallelism(mapParallelism);
        keyedResult4.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        StreamNode keyedResult3Node = graph.getStreamNode(Integer.valueOf(keyedResult3.getId()));
        StreamNode keyedResult4Node = graph.getStreamNode(Integer.valueOf(keyedResult4.getId()));
        Assert.assertEquals((long)maxParallelism, (long)keyedResult3Node.getMaxParallelism());
        Assert.assertEquals((long)maxParallelism, (long)keyedResult4Node.getMaxParallelism());
    }

    @Test
    public void testMaxParallelismWithConnectedKeyedStream() {
        int maxParallelism = 42;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator input1 = env.fromElements((Object[])new Integer[]{1, 2, 3, 4}).setMaxParallelism(128);
        SingleOutputStreamOperator input2 = env.fromElements((Object[])new Integer[]{1, 2, 3, 4}).setMaxParallelism(129);
        env.getConfig().setMaxParallelism(maxParallelism);
        SingleOutputStreamOperator keyedResult = input1.connect((DataStream)input2).keyBy((KeySelector & Serializable)value -> value, (KeySelector & Serializable)value -> value).map((CoMapFunction)new NoOpIntCoMap());
        keyedResult.addSink((SinkFunction)new DiscardingSink());
        StreamGraph graph = env.getStreamGraph();
        StreamNode keyedResultNode = graph.getStreamNode(Integer.valueOf(keyedResult.getId()));
        StreamPartitioner streamPartitioner1 = ((StreamEdge)keyedResultNode.getInEdges().get(0)).getPartitioner();
        StreamPartitioner streamPartitioner2 = ((StreamEdge)keyedResultNode.getInEdges().get(1)).getPartitioner();
    }

    @Test
    public void testSinkIdComparison() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2, 3});
        for (int i = 0; i < 32; ++i) {
            if (i % 2 == 0) {
                source.addSink((SinkFunction)new SinkFunction<Integer>(){

                    public void invoke(Integer value, SinkFunction.Context ctx) throws Exception {
                    }
                });
                continue;
            }
            source.map((MapFunction & Serializable)x -> x + 1);
        }
        env.getStreamGraph().getStreamingPlanAsJSON();
    }

    @Test
    public void testIteration() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator source = env.fromElements((Object[])new Integer[]{1, 2, 3}).name("source");
        IterativeStream iteration = source.iterate(3000L);
        iteration.name("iteration").setParallelism(2);
        SingleOutputStreamOperator map = iteration.map((MapFunction & Serializable)x -> x + 1).name("map").setParallelism(2);
        SingleOutputStreamOperator filter = map.filter((FilterFunction & Serializable)x -> false).name("filter").setParallelism(2);
        iteration.closeWith((DataStream)filter).print();
        ResourceSpec resources = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        iteration.getTransformation().setResources(resources, resources);
        StreamGraph streamGraph = env.getStreamGraph();
        for (Tuple2 iterationPair : streamGraph.getIterationSourceSinkPairs()) {
            Assert.assertNotNull((Object)((StreamNode)iterationPair.f0).getCoLocationGroup());
            Assert.assertEquals((Object)((StreamNode)iterationPair.f0).getCoLocationGroup(), (Object)((StreamNode)iterationPair.f1).getCoLocationGroup());
            Assert.assertEquals((Object)"default", (Object)((StreamNode)iterationPair.f0).getSlotSharingGroup());
            Assert.assertEquals((Object)((StreamNode)iterationPair.f0).getSlotSharingGroup(), (Object)((StreamNode)iterationPair.f1).getSlotSharingGroup());
            ResourceSpec sourceMinResources = ((StreamNode)iterationPair.f0).getMinResources();
            ResourceSpec sinkMinResources = ((StreamNode)iterationPair.f1).getMinResources();
            ResourceSpec iterationResources = sourceMinResources.merge(sinkMinResources);
            Assert.assertThat((Object)iterationResources, this.equalsResourceSpec(resources));
        }
    }

    private Matcher<ResourceSpec> equalsResourceSpec(ResourceSpec resources) {
        return new EqualsResourceSpecMatcher(resources);
    }

    @Test
    public void testEnableSlotSharing() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource sourceDataStream = env.fromElements((Object[])new Integer[]{1, 2, 3});
        SingleOutputStreamOperator mapDataStream = sourceDataStream.map((MapFunction & Serializable)x -> x + 1);
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        transformations.add(sourceDataStream.getTransformation());
        transformations.add(mapDataStream.getTransformation());
        StreamGraph streamGraph = new StreamGraphGenerator(transformations, env.getConfig(), env.getCheckpointConfig()).generate();
        Collection streamNodes = streamGraph.getStreamNodes();
        for (StreamNode streamNode : streamNodes) {
            Assert.assertEquals((Object)"default", (Object)streamNode.getSlotSharingGroup());
        }
    }

    @Test
    public void testSetManagedMemoryWeight() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator source = env.fromElements((Object[])new Integer[]{1, 2, 3}).name("source");
        source.getTransformation().setManagedMemoryWeight(123);
        source.print().name("sink");
        StreamGraph streamGraph = env.getStreamGraph();
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            int expectedWeight = streamNode.getOperatorName().contains("source") ? 123 : 1;
            Assert.assertEquals((long)expectedWeight, (long)streamNode.getManagedMemoryWeight());
        }
    }

    private static class MultipleInputOperatorFactory
    implements StreamOperatorFactory<String> {
        private MultipleInputOperatorFactory() {
        }

        public <T extends StreamOperator<String>> T createStreamOperator(StreamOperatorParameters<String> parameters) {
            throw new UnsupportedOperationException();
        }

        public void setChainingStrategy(ChainingStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        public ChainingStrategy getChainingStrategy() {
            throw new UnsupportedOperationException();
        }

        public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EqualsResourceSpecMatcher
    extends TypeSafeMatcher<ResourceSpec> {
        private final ResourceSpec resources;

        EqualsResourceSpecMatcher(ResourceSpec resources) {
            this.resources = resources;
        }

        public void describeTo(Description description) {
            description.appendText("expected resource spec ").appendValue((Object)this.resources);
        }

        protected boolean matchesSafely(ResourceSpec item) {
            return this.resources.lessThanOrEqual(item) && item.lessThanOrEqual(this.resources);
        }
    }

    static class NoOpIntCoMap
    implements CoMapFunction<Integer, Integer, Integer> {
        private static final long serialVersionUID = 1886595528149124270L;

        NoOpIntCoMap() {
        }

        public Integer map1(Integer value) throws Exception {
            return value;
        }

        public Integer map2(Integer value) throws Exception {
            return value;
        }
    }

    private static class OutputTypeConfigurableOperationWithOneInput
    extends AbstractStreamOperator<Integer>
    implements OneInputStreamOperator<Integer, Integer>,
    OutputTypeConfigurable<Integer> {
        private static final long serialVersionUID = 1L;
        TypeInformation<Integer> tpeInformation;

        private OutputTypeConfigurableOperationWithOneInput() {
        }

        public TypeInformation<Integer> getTypeInformation() {
            return this.tpeInformation;
        }

        public void processElement(StreamRecord<Integer> element) {
            this.output.collect(element);
        }

        public void processWatermark(Watermark mark) {
        }

        public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        }

        public void setOutputType(TypeInformation<Integer> outTypeInfo, ExecutionConfig executionConfig) {
            this.tpeInformation = outTypeInfo;
        }
    }

    private static class OutputTypeConfigurableOperationWithTwoInputs
    extends AbstractStreamOperator<Integer>
    implements TwoInputStreamOperator<Integer, Integer, Integer>,
    OutputTypeConfigurable<Integer> {
        private static final long serialVersionUID = 1L;
        TypeInformation<Integer> tpeInformation;

        private OutputTypeConfigurableOperationWithTwoInputs() {
        }

        public TypeInformation<Integer> getTypeInformation() {
            return this.tpeInformation;
        }

        public void setOutputType(TypeInformation<Integer> outTypeInfo, ExecutionConfig executionConfig) {
            this.tpeInformation = outTypeInfo;
        }

        public void processElement1(StreamRecord<Integer> element) throws Exception {
            this.output.collect(element);
        }

        public void processElement2(StreamRecord<Integer> element) throws Exception {
            this.output.collect(element);
        }

        public void processWatermark1(Watermark mark) throws Exception {
        }

        public void processWatermark2(Watermark mark) throws Exception {
        }

        public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        }

        public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        }

        public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<Integer>> output) {
        }
    }
}

