/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners;

import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.DateTimeBucketAssigner;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeBucketAssignerTest {
    private static final long TEST_TIME_IN_MILLIS = 1533363082011L;
    private static final MockedContext mockedContext = new MockedContext();

    @Test
    public void testGetBucketPathWithSpecifiedTimezone() {
        DateTimeBucketAssigner bucketAssigner = new DateTimeBucketAssigner(ZoneId.of("America/Los_Angeles"));
        Assert.assertEquals((Object)"2018-08-03--23", (Object)bucketAssigner.getBucketId(null, (BucketAssigner.Context)mockedContext));
    }

    @Test
    public void testGetBucketPathWithSpecifiedFormatString() {
        DateTimeBucketAssigner bucketAssigner = new DateTimeBucketAssigner("yyyy-MM-dd-HH", ZoneId.of("America/Los_Angeles"));
        Assert.assertEquals((Object)"2018-08-03-23", (Object)bucketAssigner.getBucketId(null, (BucketAssigner.Context)mockedContext));
    }

    private static class MockedContext
    implements BucketAssigner.Context {
        private MockedContext() {
        }

        public long currentProcessingTime() {
            return 1533363082011L;
        }

        public long currentWatermark() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Long timestamp() {
            return null;
        }
    }
}

