/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.timestamps.BoundedOutOfOrdernessTimestampExtractor;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.junit.Assert;
import org.junit.Test;

public class BoundedOutOfOrdernessTimestampExtractorTest {
    @Test
    public void testInitializationAndRuntime() {
        Time maxAllowedLateness = Time.milliseconds((long)10L);
        LongExtractor extractor = new LongExtractor(maxAllowedLateness);
        Assert.assertEquals((long)maxAllowedLateness.toMilliseconds(), (long)extractor.getMaxOutOfOrdernessInMillis());
        this.runValidTests(extractor);
    }

    @Test
    public void testInitialFinalAndWatermarkUnderflow() {
        LongExtractor extractor = new LongExtractor(Time.milliseconds((long)10L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)extractor.getCurrentWatermark().getTimestamp());
        extractor.extractTimestamp(Long.MIN_VALUE, -1L);
        extractor.extractTimestamp(-9223372036854775806L, -1L);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)extractor.getCurrentWatermark().getTimestamp());
        extractor.extractTimestamp(Long.MAX_VALUE, -1L);
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFF5L, (long)extractor.getCurrentWatermark().getTimestamp());
    }

    private void runValidTests(BoundedOutOfOrdernessTimestampExtractor<Long> extractor) {
        Assert.assertEquals((Object)new Watermark(Long.MIN_VALUE), (Object)extractor.getCurrentWatermark());
        Assert.assertEquals((long)13L, (long)extractor.extractTimestamp((Object)13L, 0L));
        Assert.assertEquals((long)13L, (long)extractor.extractTimestamp((Object)13L, 0L));
        Assert.assertEquals((long)14L, (long)extractor.extractTimestamp((Object)14L, 0L));
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((Object)new Watermark(10L), (Object)extractor.getCurrentWatermark());
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((long)500L, (long)extractor.extractTimestamp((Object)500L, 0L));
        Assert.assertEquals((Object)new Watermark(490L), (Object)extractor.getCurrentWatermark());
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)extractor.extractTimestamp((Object)0x7FFFFFFFFFFFFFFEL, 0L));
        Assert.assertEquals((Object)new Watermark(0x7FFFFFFFFFFFFFF4L), (Object)extractor.getCurrentWatermark());
    }

    private static class LongExtractor
    extends BoundedOutOfOrdernessTimestampExtractor<Long> {
        private static final long serialVersionUID = 1L;

        public LongExtractor(Time maxAllowedLateness) {
            super(maxAllowedLateness);
        }

        public long extractTimestamp(Long element) {
            return element;
        }
    }
}

