/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamContextEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.environment.StreamPlanEnvironment;
import org.apache.flink.streaming.api.functions.source.ContinuousFileMonitoringFunction;
import org.apache.flink.streaming.api.functions.source.ContinuousFileReaderOperator;
import org.apache.flink.streaming.api.functions.source.FileMonitoringFunction;
import org.apache.flink.streaming.api.functions.source.FileProcessingMode;
import org.apache.flink.streaming.api.functions.source.FileReadFunction;
import org.apache.flink.streaming.api.functions.source.FromElementsFunction;
import org.apache.flink.streaming.api.functions.source.FromIteratorFunction;
import org.apache.flink.streaming.api.functions.source.FromSplittableIteratorFunction;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.functions.source.ParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SocketTextStreamFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.StatefulSequenceSource;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SplittableIterator;
import org.apache.flink.util.StringUtils;

@Public
public abstract class StreamExecutionEnvironment {
    public static final String DEFAULT_JOB_NAME = "Flink Streaming Job";
    private static final TimeCharacteristic DEFAULT_TIME_CHARACTERISTIC = TimeCharacteristic.ProcessingTime;
    private static final long DEFAULT_NETWORK_BUFFER_TIMEOUT = 100L;
    private static StreamExecutionEnvironmentFactory contextEnvironmentFactory = null;
    private static final ThreadLocal<StreamExecutionEnvironmentFactory> threadLocalContextEnvironmentFactory = new ThreadLocal();
    private static int defaultLocalParallelism = Runtime.getRuntime().availableProcessors();
    private final ExecutionConfig config = new ExecutionConfig();
    private final CheckpointConfig checkpointCfg = new CheckpointConfig();
    protected final List<Transformation<?>> transformations = new ArrayList();
    private long bufferTimeout = 100L;
    protected boolean isChainingEnabled = true;
    private StateBackend defaultStateBackend;
    private TimeCharacteristic timeCharacteristic = DEFAULT_TIME_CHARACTERISTIC;
    protected final List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile = new ArrayList<Tuple2<String, DistributedCache.DistributedCacheEntry>>();

    public ExecutionConfig getConfig() {
        return this.config;
    }

    public List<Tuple2<String, DistributedCache.DistributedCacheEntry>> getCachedFiles() {
        return this.cacheFile;
    }

    public StreamExecutionEnvironment setParallelism(int parallelism) {
        this.config.setParallelism(parallelism);
        return this;
    }

    public StreamExecutionEnvironment setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("maxParallelism is out of bounds 0 < maxParallelism <= 32768. Found: " + maxParallelism));
        this.config.setMaxParallelism(maxParallelism);
        return this;
    }

    public int getParallelism() {
        return this.config.getParallelism();
    }

    public int getMaxParallelism() {
        return this.config.getMaxParallelism();
    }

    public StreamExecutionEnvironment setBufferTimeout(long timeoutMillis) {
        if (timeoutMillis < -1L) {
            throw new IllegalArgumentException("Timeout of buffer must be non-negative or -1");
        }
        this.bufferTimeout = timeoutMillis;
        return this;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    @PublicEvolving
    public StreamExecutionEnvironment disableOperatorChaining() {
        this.isChainingEnabled = false;
        return this;
    }

    @PublicEvolving
    public boolean isChainingEnabled() {
        return this.isChainingEnabled;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointCfg;
    }

    public StreamExecutionEnvironment enableCheckpointing(long interval) {
        this.checkpointCfg.setCheckpointInterval(interval);
        return this;
    }

    public StreamExecutionEnvironment enableCheckpointing(long interval, CheckpointingMode mode) {
        this.checkpointCfg.setCheckpointingMode(mode);
        this.checkpointCfg.setCheckpointInterval(interval);
        return this;
    }

    @Deprecated
    @PublicEvolving
    public StreamExecutionEnvironment enableCheckpointing(long interval, CheckpointingMode mode, boolean force) {
        this.checkpointCfg.setCheckpointingMode(mode);
        this.checkpointCfg.setCheckpointInterval(interval);
        this.checkpointCfg.setForceCheckpointing(force);
        return this;
    }

    @Deprecated
    @PublicEvolving
    public StreamExecutionEnvironment enableCheckpointing() {
        this.checkpointCfg.setCheckpointInterval(500L);
        return this;
    }

    public long getCheckpointInterval() {
        return this.checkpointCfg.getCheckpointInterval();
    }

    @Deprecated
    @PublicEvolving
    public boolean isForceCheckpointing() {
        return this.checkpointCfg.isForceCheckpointing();
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointCfg.getCheckpointingMode();
    }

    @PublicEvolving
    public StreamExecutionEnvironment setStateBackend(StateBackend backend) {
        this.defaultStateBackend = (StateBackend)Preconditions.checkNotNull((Object)backend);
        return this;
    }

    @Deprecated
    @PublicEvolving
    public StreamExecutionEnvironment setStateBackend(AbstractStateBackend backend) {
        this.defaultStateBackend = (StateBackend)Preconditions.checkNotNull((Object)backend);
        return this;
    }

    @PublicEvolving
    public StateBackend getStateBackend() {
        return this.defaultStateBackend;
    }

    @PublicEvolving
    public void setRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.config.setRestartStrategy(restartStrategyConfiguration);
    }

    @PublicEvolving
    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        return this.config.getRestartStrategy();
    }

    @Deprecated
    @PublicEvolving
    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        this.config.setNumberOfExecutionRetries(numberOfExecutionRetries);
    }

    @Deprecated
    @PublicEvolving
    public int getNumberOfExecutionRetries() {
        return this.config.getNumberOfExecutionRetries();
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        this.config.addDefaultKryoSerializer(type, serializer);
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.addDefaultKryoSerializer(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        this.config.registerTypeWithKryoSerializer(type, serializer);
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        this.config.registerTypeWithKryoSerializer(type, serializerClass);
    }

    public void registerType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(type);
        if (typeInfo instanceof PojoTypeInfo) {
            this.config.registerPojoType(type);
        } else {
            this.config.registerKryoType(type);
        }
    }

    @PublicEvolving
    public void setStreamTimeCharacteristic(TimeCharacteristic characteristic) {
        this.timeCharacteristic = (TimeCharacteristic)((Object)Preconditions.checkNotNull((Object)((Object)characteristic)));
        if (characteristic == TimeCharacteristic.ProcessingTime) {
            this.getConfig().setAutoWatermarkInterval(0L);
        } else {
            this.getConfig().setAutoWatermarkInterval(200L);
        }
    }

    @PublicEvolving
    public TimeCharacteristic getStreamTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public DataStreamSource<Long> generateSequence(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("Start of sequence must not be greater than the end");
        }
        return this.addSource(new StatefulSequenceSource(from, to), "Sequence Source");
    }

    @SafeVarargs
    public final <OUT> DataStreamSource<OUT> fromElements(OUT ... data) {
        TypeInformation typeInfo;
        if (data.length == 0) {
            throw new IllegalArgumentException("fromElements needs at least one element as argument");
        }
        try {
            typeInfo = TypeExtractor.getForObject(data[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + data[0].getClass().getName() + "; please specify the TypeInformation manually via StreamExecutionEnvironment#fromElements(Collection, TypeInformation)", e);
        }
        return this.fromCollection(Arrays.asList(data), typeInfo);
    }

    @SafeVarargs
    public final <OUT> DataStreamSource<OUT> fromElements(Class<OUT> type, OUT ... data) {
        TypeInformation typeInfo;
        if (data.length == 0) {
            throw new IllegalArgumentException("fromElements needs at least one element as argument");
        }
        try {
            typeInfo = TypeExtractor.getForClass(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + type.getName() + "; please specify the TypeInformation manually via StreamExecutionEnvironment#fromElements(Collection, TypeInformation)", e);
        }
        return this.fromCollection(Arrays.asList(data), typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Collection<OUT> data) {
        TypeInformation typeInfo;
        Preconditions.checkNotNull(data, (String)"Collection must not be null");
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Collection must not be empty");
        }
        OUT first = data.iterator().next();
        if (first == null) {
            throw new IllegalArgumentException("Collection must not contain null elements");
        }
        try {
            typeInfo = TypeExtractor.getForObject(first);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + first.getClass() + "; please specify the TypeInformation manually via StreamExecutionEnvironment#fromElements(Collection, TypeInformation)", e);
        }
        return this.fromCollection(data, typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Collection<OUT> data, TypeInformation<OUT> typeInfo) {
        FromElementsFunction<OUT> function;
        Preconditions.checkNotNull(data, (String)"Collection must not be null");
        FromElementsFunction.checkCollection(data, typeInfo.getTypeClass());
        try {
            function = new FromElementsFunction<OUT>(typeInfo.createSerializer(this.getConfig()), data);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.addSource(function, "Collection Source", typeInfo).setParallelism(1);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Iterator<OUT> data, Class<OUT> type) {
        return this.fromCollection(data, TypeExtractor.getForClass(type));
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Iterator<OUT> data, TypeInformation<OUT> typeInfo) {
        Preconditions.checkNotNull(data, (String)"The iterator must not be null");
        FromIteratorFunction<OUT> function = new FromIteratorFunction<OUT>(data);
        return this.addSource(function, "Collection Source", typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, Class<OUT> type) {
        return this.fromParallelCollection(iterator, TypeExtractor.getForClass(type));
    }

    public <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, TypeInformation<OUT> typeInfo) {
        return this.fromParallelCollection(iterator, typeInfo, "Parallel Collection Source");
    }

    private <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, TypeInformation<OUT> typeInfo, String operatorName) {
        return this.addSource(new FromSplittableIteratorFunction<OUT>(iterator), operatorName, typeInfo);
    }

    public DataStreamSource<String> readTextFile(String filePath) {
        return this.readTextFile(filePath, "UTF-8");
    }

    public DataStreamSource<String> readTextFile(String filePath, String charsetName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)filePath) ? 1 : 0) != 0, (Object)"The file path must not be null or blank.");
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        format.setFilesFilter(FilePathFilter.createDefaultFilter());
        BasicTypeInfo typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        format.setCharsetName(charsetName);
        return this.readFile((FileInputFormat)format, filePath, FileProcessingMode.PROCESS_ONCE, -1L, (TypeInformation)typeInfo);
    }

    public <OUT> DataStreamSource<OUT> readFile(FileInputFormat<OUT> inputFormat, String filePath) {
        return this.readFile(inputFormat, filePath, FileProcessingMode.PROCESS_ONCE, -1L);
    }

    @Deprecated
    @PublicEvolving
    public <OUT> DataStreamSource<OUT> readFile(FileInputFormat<OUT> inputFormat, String filePath, FileProcessingMode watchType, long interval, FilePathFilter filter) {
        TypeInformation typeInformation;
        inputFormat.setFilesFilter(filter);
        try {
            typeInformation = TypeExtractor.getInputFormatTypes(inputFormat);
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
        return this.readFile(inputFormat, filePath, watchType, interval, typeInformation);
    }

    @PublicEvolving
    public <OUT> DataStreamSource<OUT> readFile(FileInputFormat<OUT> inputFormat, String filePath, FileProcessingMode watchType, long interval) {
        TypeInformation typeInformation;
        try {
            typeInformation = TypeExtractor.getInputFormatTypes(inputFormat);
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
        return this.readFile(inputFormat, filePath, watchType, interval, typeInformation);
    }

    @Deprecated
    public DataStream<String> readFileStream(String filePath, long intervalMillis, FileMonitoringFunction.WatchType watchType) {
        DataStreamSource<Tuple3<String, Long, Long>> source = this.addSource(new FileMonitoringFunction(filePath, intervalMillis, watchType), "Read File Stream source");
        return source.flatMap(new FileReadFunction());
    }

    @PublicEvolving
    public <OUT> DataStreamSource<OUT> readFile(FileInputFormat<OUT> inputFormat, String filePath, FileProcessingMode watchType, long interval, TypeInformation<OUT> typeInformation) {
        Preconditions.checkNotNull(inputFormat, (String)"InputFormat must not be null.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)filePath) ? 1 : 0) != 0, (Object)"The file path must not be null or blank.");
        inputFormat.setFilePath(filePath);
        return this.createFileInput(inputFormat, typeInformation, "Custom File Source", watchType, interval);
    }

    @Deprecated
    public DataStreamSource<String> socketTextStream(String hostname, int port, char delimiter, long maxRetry) {
        return this.socketTextStream(hostname, port, String.valueOf(delimiter), maxRetry);
    }

    @PublicEvolving
    public DataStreamSource<String> socketTextStream(String hostname, int port, String delimiter, long maxRetry) {
        return this.addSource(new SocketTextStreamFunction(hostname, port, delimiter, maxRetry), "Socket Stream");
    }

    @Deprecated
    public DataStreamSource<String> socketTextStream(String hostname, int port, char delimiter) {
        return this.socketTextStream(hostname, port, delimiter, 0L);
    }

    @PublicEvolving
    public DataStreamSource<String> socketTextStream(String hostname, int port, String delimiter) {
        return this.socketTextStream(hostname, port, delimiter, 0L);
    }

    @PublicEvolving
    public DataStreamSource<String> socketTextStream(String hostname, int port) {
        return this.socketTextStream(hostname, port, "\n");
    }

    @PublicEvolving
    public <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat) {
        return this.createInput(inputFormat, TypeExtractor.getInputFormatTypes(inputFormat));
    }

    @PublicEvolving
    public <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> typeInfo) {
        DataStreamSource<OUT> source;
        if (inputFormat instanceof FileInputFormat) {
            FileInputFormat format = (FileInputFormat)inputFormat;
            source = this.createFileInput(format, typeInfo, "Custom File source", FileProcessingMode.PROCESS_ONCE, -1L);
        } else {
            source = this.createInput(inputFormat, typeInfo, "Custom Source");
        }
        return source;
    }

    private <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> typeInfo, String sourceName) {
        InputFormatSourceFunction<OUT> function = new InputFormatSourceFunction<OUT>(inputFormat, typeInfo);
        return this.addSource(function, sourceName, typeInfo);
    }

    private <OUT> DataStreamSource<OUT> createFileInput(FileInputFormat<OUT> inputFormat, TypeInformation<OUT> typeInfo, String sourceName, FileProcessingMode monitoringMode, long interval) {
        Preconditions.checkNotNull(inputFormat, (String)"Unspecified file input format.");
        Preconditions.checkNotNull(typeInfo, (String)"Unspecified output type information.");
        Preconditions.checkNotNull((Object)sourceName, (String)"Unspecified name for the source.");
        Preconditions.checkNotNull((Object)((Object)monitoringMode), (String)"Unspecified monitoring mode.");
        Preconditions.checkArgument((monitoringMode.equals((Object)FileProcessingMode.PROCESS_ONCE) || interval >= 1L ? 1 : 0) != 0, (Object)"The path monitoring interval cannot be less than 1 ms.");
        ContinuousFileMonitoringFunction<OUT> monitoringFunction = new ContinuousFileMonitoringFunction<OUT>(inputFormat, monitoringMode, this.getParallelism(), interval);
        ContinuousFileReaderOperator<OUT> reader = new ContinuousFileReaderOperator<OUT>(inputFormat);
        SingleOutputStreamOperator<OUT> source = this.addSource(monitoringFunction, sourceName).transform("Split Reader: " + sourceName, typeInfo, reader);
        return new DataStreamSource<OUT>(source);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function) {
        return this.addSource(function, "Custom Source");
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, String sourceName) {
        return this.addSource(function, sourceName, null);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, TypeInformation<OUT> typeInfo) {
        return this.addSource(function, "Custom Source", typeInfo);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, String sourceName, TypeInformation<OUT> typeInfo) {
        if (function instanceof ResultTypeQueryable) {
            typeInfo = ((ResultTypeQueryable)function).getProducedType();
        }
        if (typeInfo == null) {
            try {
                typeInfo = TypeExtractor.createTypeInfo(SourceFunction.class, function.getClass(), (int)0, null, null);
            }
            catch (InvalidTypesException e) {
                typeInfo = new MissingTypeInfo(sourceName, e);
            }
        }
        boolean isParallel = function instanceof ParallelSourceFunction;
        this.clean(function);
        StreamSource sourceOperator = new StreamSource(function);
        return new DataStreamSource(this, typeInfo, sourceOperator, isParallel, sourceName);
    }

    public JobExecutionResult execute() throws Exception {
        return this.execute(DEFAULT_JOB_NAME);
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        Preconditions.checkNotNull((Object)jobName, (String)"Streaming Job name should not be null.");
        return this.execute(this.getStreamGraph(jobName));
    }

    @Internal
    public abstract JobExecutionResult execute(StreamGraph var1) throws Exception;

    @Internal
    public StreamGraph getStreamGraph() {
        return this.getStreamGraphGenerator().generate();
    }

    @Internal
    public StreamGraph getStreamGraph(String jobName) {
        return this.getStreamGraphGenerator().setJobName(jobName).generate();
    }

    private StreamGraphGenerator getStreamGraphGenerator() {
        if (this.transformations.size() <= 0) {
            throw new IllegalStateException("No operators defined in streaming topology. Cannot execute.");
        }
        return new StreamGraphGenerator(this.transformations, this.config, this.checkpointCfg).setStateBackend(this.defaultStateBackend).setChaining(this.isChainingEnabled).setUserArtifacts(this.cacheFile).setTimeCharacteristic(this.timeCharacteristic).setDefaultBufferTimeout(this.bufferTimeout);
    }

    public String getExecutionPlan() {
        return this.getStreamGraph().getStreamingPlanAsJSON();
    }

    @Internal
    public <F> F clean(F f) {
        if (this.getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, (ExecutionConfig.ClosureCleanerLevel)this.getConfig().getClosureCleanerLevel(), (boolean)true);
        }
        ClosureCleaner.ensureSerializable(f);
        return f;
    }

    @Internal
    public void addOperator(Transformation<?> transformation) {
        Preconditions.checkNotNull(transformation, (String)"transformation must not be null.");
        this.transformations.add(transformation);
    }

    public static StreamExecutionEnvironment getExecutionEnvironment() {
        return Utils.resolveFactory(threadLocalContextEnvironmentFactory, (Object)contextEnvironmentFactory).map(StreamExecutionEnvironmentFactory::createExecutionEnvironment).orElseGet(StreamExecutionEnvironment::createStreamExecutionEnvironment);
    }

    private static StreamExecutionEnvironment createStreamExecutionEnvironment() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (env instanceof ContextEnvironment) {
            return new StreamContextEnvironment((ContextEnvironment)env);
        }
        if (env instanceof OptimizerPlanEnvironment || env instanceof PreviewPlanEnvironment) {
            return new StreamPlanEnvironment(env);
        }
        return StreamExecutionEnvironment.createLocalEnvironment();
    }

    public static LocalStreamEnvironment createLocalEnvironment() {
        return StreamExecutionEnvironment.createLocalEnvironment(defaultLocalParallelism);
    }

    public static LocalStreamEnvironment createLocalEnvironment(int parallelism) {
        return StreamExecutionEnvironment.createLocalEnvironment(parallelism, new Configuration());
    }

    public static LocalStreamEnvironment createLocalEnvironment(int parallelism, Configuration configuration) {
        LocalStreamEnvironment currentEnvironment = new LocalStreamEnvironment(configuration);
        currentEnvironment.setParallelism(parallelism);
        return currentEnvironment;
    }

    @PublicEvolving
    public static StreamExecutionEnvironment createLocalEnvironmentWithWebUI(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (String)"conf");
        conf.setBoolean("local.start-webserver", true);
        if (!conf.contains(RestOptions.PORT)) {
            conf.setInteger(RestOptions.PORT, ((Integer)RestOptions.PORT.defaultValue()).intValue());
        }
        return StreamExecutionEnvironment.createLocalEnvironment(defaultLocalParallelism, conf);
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteStreamEnvironment(host, port, jarFiles);
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, String ... jarFiles) {
        RemoteStreamEnvironment env = new RemoteStreamEnvironment(host, port, jarFiles);
        env.setParallelism(parallelism);
        return env;
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Configuration clientConfig, String ... jarFiles) {
        return new RemoteStreamEnvironment(host, port, clientConfig, jarFiles);
    }

    @PublicEvolving
    public static int getDefaultLocalParallelism() {
        return defaultLocalParallelism;
    }

    @PublicEvolving
    public static void setDefaultLocalParallelism(int parallelism) {
        defaultLocalParallelism = parallelism;
    }

    protected static void initializeContextEnvironment(StreamExecutionEnvironmentFactory ctx) {
        contextEnvironmentFactory = ctx;
        threadLocalContextEnvironmentFactory.set(contextEnvironmentFactory);
    }

    protected static void resetContextEnvironment() {
        contextEnvironmentFactory = null;
        threadLocalContextEnvironmentFactory.remove();
    }

    public void registerCachedFile(String filePath, String name) {
        this.registerCachedFile(filePath, name, false);
    }

    public void registerCachedFile(String filePath, String name, boolean executable) {
        this.cacheFile.add((Tuple2<String, DistributedCache.DistributedCacheEntry>)new Tuple2((Object)name, (Object)new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(executable))));
    }
}

