/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2Serializer;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;

public class OperatorSnapshotUtil {
    public static String getResourceFilename(String filename) {
        ClassLoader cl = OperatorSnapshotUtil.class.getClassLoader();
        URL resource = cl.getResource(filename);
        return resource.getFile();
    }

    public static void writeStateHandle(OperatorSubtaskState state, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        try (DataOutputStream dos = new DataOutputStream(out);){
            dos.writeInt(0);
            SavepointV2Serializer.serializeStreamStateHandle(null, (DataOutputStream)dos);
            StateObjectCollection rawOperatorState = state.getRawOperatorState();
            if (rawOperatorState != null) {
                dos.writeInt(rawOperatorState.size());
                for (Object operatorStateHandle : rawOperatorState) {
                    SavepointV2Serializer.serializeOperatorStateHandle((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedOperatorState = state.getManagedOperatorState();
            if (managedOperatorState != null) {
                dos.writeInt(managedOperatorState.size());
                for (Object operatorStateHandle : managedOperatorState) {
                    SavepointV2Serializer.serializeOperatorStateHandle((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection rawKeyedState = state.getRawKeyedState();
            if (rawKeyedState != null) {
                dos.writeInt(rawKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : rawKeyedState) {
                    SavepointV2Serializer.serializeKeyedStateHandle((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedKeyedState = state.getManagedKeyedState();
            if (managedKeyedState != null) {
                dos.writeInt(managedKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : managedKeyedState) {
                    SavepointV2Serializer.serializeKeyedStateHandle((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            dos.flush();
        }
    }

    public static OperatorSubtaskState readStateHandle(String path) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(path);
        try (DataInputStream dis = new DataInputStream(in);){
            dis.readInt();
            SavepointV2Serializer.deserializeStreamStateHandle((DataInputStream)dis);
            ArrayList<OperatorStateHandle> rawOperatorState = null;
            int numRawOperatorStates = dis.readInt();
            if (numRawOperatorStates >= 0) {
                rawOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numRawOperatorStates; ++i) {
                    OperatorStateHandle operatorState = SavepointV2Serializer.deserializeOperatorStateHandle((DataInputStream)dis);
                    rawOperatorState.add(operatorState);
                }
            }
            ArrayList<OperatorStateHandle> managedOperatorState = null;
            int numManagedOperatorStates = dis.readInt();
            if (numManagedOperatorStates >= 0) {
                managedOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numManagedOperatorStates; ++i) {
                    OperatorStateHandle operatorState = SavepointV2Serializer.deserializeOperatorStateHandle((DataInputStream)dis);
                    managedOperatorState.add(operatorState);
                }
            }
            ArrayList<KeyedStateHandle> rawKeyedState = null;
            int numRawKeyedStates = dis.readInt();
            if (numRawKeyedStates >= 0) {
                rawKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numRawKeyedStates; ++i) {
                    KeyedStateHandle keyedState = SavepointV2Serializer.deserializeKeyedStateHandle((DataInputStream)dis);
                    rawKeyedState.add(keyedState);
                }
            }
            ArrayList<KeyedStateHandle> managedKeyedState = null;
            int numManagedKeyedStates = dis.readInt();
            if (numManagedKeyedStates >= 0) {
                managedKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numManagedKeyedStates; ++i) {
                    KeyedStateHandle keyedState = SavepointV2Serializer.deserializeKeyedStateHandle((DataInputStream)dis);
                    managedKeyedState.add(keyedState);
                }
            }
            OperatorSubtaskState operatorSubtaskState = new OperatorSubtaskState(new StateObjectCollection(managedOperatorState), new StateObjectCollection(rawOperatorState), new StateObjectCollection(managedKeyedState), new StateObjectCollection(rawKeyedState));
            return operatorSubtaskState;
        }
    }
}

