/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.MockStreamStatusMaintainer;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializerImpl;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.util.MockStreamTask;

public class MockStreamTaskBuilder {
    private final Environment environment;
    private String name = "Mock Task";
    private Object checkpointLock = new Object();
    private StreamConfig config = new StreamConfig(new Configuration());
    private ExecutionConfig executionConfig = new ExecutionConfig();
    private CloseableRegistry closableRegistry = new CloseableRegistry();
    private StreamStatusMaintainer streamStatusMaintainer = new MockStreamStatusMaintainer();
    private CheckpointStorageWorkerView checkpointStorage;
    private ProcessingTimeService processingTimeService = new TestProcessingTimeService();
    private StreamTaskStateInitializer streamTaskStateInitializer;
    private BiConsumer<String, Throwable> handleAsyncException = (message, throwable) -> {};
    private Map<String, Accumulator<?, ?>> accumulatorMap = Collections.emptyMap();

    public MockStreamTaskBuilder(Environment environment) throws Exception {
        this.environment = environment;
        MemoryStateBackend stateBackend = new MemoryStateBackend();
        this.checkpointStorage = stateBackend.createCheckpointStorage(new JobID());
        this.streamTaskStateInitializer = new StreamTaskStateInitializerImpl(environment, (StateBackend)stateBackend, this.processingTimeService);
    }

    public MockStreamTaskBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public MockStreamTaskBuilder setCheckpointLock(Object checkpointLock) {
        this.checkpointLock = checkpointLock;
        return this;
    }

    public MockStreamTaskBuilder setConfig(StreamConfig config) {
        this.config = config;
        return this;
    }

    public MockStreamTaskBuilder setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
        return this;
    }

    public MockStreamTaskBuilder setStreamTaskStateInitializer(StreamTaskStateInitializer streamTaskStateInitializer) {
        this.streamTaskStateInitializer = streamTaskStateInitializer;
        return this;
    }

    public MockStreamTaskBuilder setClosableRegistry(CloseableRegistry closableRegistry) {
        this.closableRegistry = closableRegistry;
        return this;
    }

    public MockStreamTaskBuilder setStreamStatusMaintainer(StreamStatusMaintainer streamStatusMaintainer) {
        this.streamStatusMaintainer = streamStatusMaintainer;
        return this;
    }

    public MockStreamTaskBuilder setCheckpointStorage(CheckpointStorage checkpointStorage) {
        this.checkpointStorage = checkpointStorage;
        return this;
    }

    public MockStreamTaskBuilder setProcessingTimeService(ProcessingTimeService processingTimeService) {
        this.processingTimeService = processingTimeService;
        return this;
    }

    public MockStreamTaskBuilder setHandleAsyncException(BiConsumer<String, Throwable> handleAsyncException) {
        this.handleAsyncException = handleAsyncException;
        return this;
    }

    public MockStreamTask build() {
        return new MockStreamTask(this.environment, this.name, this.checkpointLock, this.config, this.executionConfig, this.streamTaskStateInitializer, this.closableRegistry, this.streamStatusMaintainer, this.checkpointStorage, this.processingTimeService, this.handleAsyncException, this.accumulatorMap);
    }
}

