/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.RecordOrEventCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.TestGlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.mockito.Mockito;

public class StreamMockEnvironment
implements Environment {
    private final TaskInfo taskInfo;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<InputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobID jobID;
    private final ExecutionAttemptID executionAttemptID;
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry kvStateRegistry;
    private final int bufferSize;
    private final ExecutionConfig executionConfig;
    private final TaskStateManager taskStateManager;
    private final GlobalAggregateManager aggregateManager;
    private volatile boolean wasFailedExternally = false;
    private TaskEventDispatcher taskEventDispatcher = (TaskEventDispatcher)Mockito.mock(TaskEventDispatcher.class);
    private TaskManagerRuntimeInfo taskManagerRuntimeInfo = new TestingTaskManagerRuntimeInfo();

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
        this(new JobID(), new ExecutionAttemptID(0L, 0L), jobConfig, taskConfig, executionConfig, memorySize, inputSplitProvider, bufferSize, taskStateManager);
    }

    public StreamMockEnvironment(JobID jobID, ExecutionAttemptID executionAttemptID, Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
        this.jobID = jobID;
        this.executionAttemptID = executionAttemptID;
        int subtaskIndex = 0;
        this.taskInfo = new TaskInfo("", 1, subtaskIndex, 1, 0);
        this.jobConfiguration = jobConfig;
        this.taskConfiguration = taskConfig;
        this.inputs = new LinkedList<InputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = new MemoryManager(memorySize, 1);
        this.ioManager = new IOManagerAsync();
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.aggregateManager = new TestGlobalAggregateManager();
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.executionConfig = executionConfig;
        this.accumulatorRegistry = new AccumulatorRegistry(jobID, this.getExecutionId());
        KvStateRegistry registry = new KvStateRegistry();
        this.kvStateRegistry = registry.createTaskRegistry(jobID, this.getJobVertexId());
    }

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
        this(jobConfig, taskConfig, new ExecutionConfig(), memorySize, inputSplitProvider, bufferSize, taskStateManager);
    }

    public void addInputGate(InputGate gate) {
        this.inputs.add(gate);
    }

    public <T> void addOutput(Collection<Object> outputList, TypeSerializer<T> serializer) {
        try {
            this.outputs.add((ResultPartitionWriter)new RecordOrEventCollectingResultPartitionWriter(outputList, (BufferProvider)new TestPooledBufferProvider(Integer.MAX_VALUE), serializer));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public ClassLoader getUserClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public InputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public InputGate[] getAllInputGates() {
        InputGate[] gates = new InputGate[this.inputs.size()];
        this.inputs.toArray(gates);
        return gates;
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public JobVertexID getJobVertexId() {
        return new JobVertexID(new byte[16]);
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionAttemptID;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.aggregateManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        this.taskStateManager.reportTaskStateSnapshots(new CheckpointMetaData(checkpointId, 0L), checkpointMetrics, subtaskState, null);
    }

    public void declineCheckpoint(long checkpointId, Throwable cause) {
    }

    public void failExternally(Throwable cause) {
        this.wasFailedExternally = true;
    }

    public boolean wasFailedExternally() {
        return this.wasFailedExternally;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerRuntimeInfo;
    }

    public void setTaskManagerInfo(TaskManagerRuntimeInfo taskManagerRuntimeInfo) {
        this.taskManagerRuntimeInfo = taskManagerRuntimeInfo;
    }

    public TaskMetricGroup getMetricGroup() {
        return UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
    }
}

