/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.streaming.runtime.tasks.CheckpointExceptionHandler;
import org.apache.flink.streaming.runtime.tasks.CheckpointExceptionHandlerFactory;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointExceptionHandlerTest
extends TestLogger {
    @Test
    public void testDecliningHandler() {
        DeclineDummyEnvironment environment = new DeclineDummyEnvironment();
        CheckpointExceptionHandlerFactory checkpointExceptionHandlerFactory = new CheckpointExceptionHandlerFactory();
        CheckpointExceptionHandler exceptionHandler = checkpointExceptionHandlerFactory.createCheckpointExceptionHandler((Environment)environment);
        CheckpointMetaData failedCheckpointMetaData = new CheckpointMetaData(42L, 4711L);
        Exception testException = new Exception("test");
        try {
            exceptionHandler.tryHandleCheckpointException(failedCheckpointMetaData, testException);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception not handled, but rethrown.");
        }
        Assert.assertEquals((long)failedCheckpointMetaData.getCheckpointId(), (long)environment.getLastDeclinedCheckpointId());
        Assert.assertEquals((Object)testException, (Object)environment.getLastDeclinedCheckpointCause());
    }

    static final class DeclineDummyEnvironment
    extends DummyEnvironment {
        private long lastDeclinedCheckpointId = Long.MIN_VALUE;
        private Throwable lastDeclinedCheckpointCause = null;

        DeclineDummyEnvironment() {
            super("test", 1, 0);
        }

        public void declineCheckpoint(long checkpointId, Throwable cause) {
            this.lastDeclinedCheckpointId = checkpointId;
            this.lastDeclinedCheckpointCause = cause;
        }

        long getLastDeclinedCheckpointId() {
            return this.lastDeclinedCheckpointId;
        }

        Throwable getLastDeclinedCheckpointCause() {
            return this.lastDeclinedCheckpointCause;
        }
    }
}

