/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichAggregateFunction;
import org.apache.flink.api.common.functions.RichFoldFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.AllWindowedStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.CountEvictor;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class AllWindowTranslationTest {
    @Test(expected=UnsupportedOperationException.class)
    public void testReduceWithRichReducerFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new RichReduceFunction<Tuple2<String, Integer>>(){
            private static final long serialVersionUID = -6448847205314995812L;

            public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                return null;
            }
        });
        Assert.fail((String)"exception was not thrown");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAggregateWithRichFunctionFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate(new DummyRichAggregationFunction());
        Assert.fail((String)"exception was not thrown");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFoldWithRichFolderFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).fold((Object)new Tuple2((Object)"", (Object)0), (FoldFunction)new RichFoldFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){
            private static final long serialVersionUID = -6448847205314995812L;

            public Tuple2<String, Integer> fold(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                return null;
            }
        });
        Assert.fail((String)"exception was not thrown");
    }

    @Test
    public void testSessionWithFoldFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        AllWindowedStream windowedStream = env.fromElements((Object[])new String[]{"Hello", "Ciao"}).windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L)));
        try {
            windowedStream.fold((Object)"", (FoldFunction)new FoldFunction<String, String>(){
                private static final long serialVersionUID = -4567902917104921706L;

                public String fold(String accumulator, String value) throws Exception {
                    return accumulator;
                }
            });
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.fail((String)"The fold call should fail.");
    }

    @Test
    public void testMergingAssignerWithNonMergingTriggerFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        AllWindowedStream windowedStream = env.fromElements((Object[])new String[]{"Hello", "Ciao"}).windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L)));
        try {
            windowedStream.trigger((Trigger)new Trigger<String, TimeWindow>(){
                private static final long serialVersionUID = 6558046711583024443L;

                public TriggerResult onElement(String element, long timestamp, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public TriggerResult onProcessingTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public TriggerResult onEventTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public boolean canMerge() {
                    return false;
                }

                public void clear(TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                }
            });
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.fail((String)"The trigger call should fail.");
    }

    @Test
    public void testMergingWindowsWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L))).evictor((Evictor)CountEvictor.of((long)5L)).process((ProcessAllWindowFunction)new TestProcessAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof EventTimeSessionWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)reducer, (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)new DummyReducer(), (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithProcessWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)reducer, (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithProcessWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)new DummyReducer(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer, (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithPreReducerEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((ReduceFunction)reducer, (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (AllWindowFunction)new TestAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (AllWindowFunction)new TestAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof TimeEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).fold((Object)new Tuple3((Object)"", (Object)"", (Object)1), (FoldFunction)new DummyFolder());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).fold((Object)new Tuple3((Object)"", (Object)"", (Object)0), (FoldFunction)new DummyFolder());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).fold((Object)new Tuple3((Object)"", (Object)"", (Object)0), (FoldFunction)new DummyFolder(), (AllWindowFunction)new AllWindowFunction<Tuple3<String, String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple3<String, String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : values) {
                    out.collect((Object)new Tuple2(in.f0, in.f2));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).fold((Object)new Tuple3((Object)"", (Object)"empty", (Object)0), (FoldFunction)new DummyFolder(), (AllWindowFunction)new AllWindowFunction<Tuple3<String, String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple3<String, String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : values) {
                    out.collect((Object)new Tuple2(in.f0, in.f2));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithProcessAllWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).fold((Object)new Tuple3((Object)"", (Object)"", (Object)0), (FoldFunction)new DummyFolder(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple3<String, String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple3<String, String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : values) {
                    out.collect((Object)new Tuple2(in.f0, in.f2));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithProcessAllWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).fold((Object)new Tuple3((Object)"", (Object)"empty", (Object)0), (FoldFunction)new DummyFolder(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple3<String, String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple3<String, String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : values) {
                    out.collect((Object)new Tuple2(in.f0, in.f2));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).fold((Object)new Tuple3((Object)"", (Object)"", (Object)1), (FoldFunction)new DummyFolder(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple3<String, String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple3<String, String, Integer>> elements, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        winOperator.setOutputType(window1.getType(), new ExecutionConfig());
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithPreFolderEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((Object)new Tuple3((Object)"", (Object)"", (Object)0), (FoldFunction)new DummyFolder(), (AllWindowFunction)new AllWindowFunction<Tuple3<String, String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple3<String, String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple3<String, String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f1, in.f2));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyProcessingTimeTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).fold((Object)new Tuple3((Object)"", (Object)"", (Object)1), (FoldFunction)new DummyFolder());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof FoldingStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testFoldWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).fold((Object)new Tuple3((Object)"", (Object)"", (Object)1), (FoldFunction)new DummyFolder());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        winOperator.setOutputType(window1.getType(), new ExecutionConfig());
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof TimeEvictor));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    private static <K, IN, OUT> void processElementAndEnsureOutput(OneInputStreamOperator<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, IN element) throws Exception {
        KeyedOneInputStreamOperatorTestHarness<K, IN, OUT> testHarness = new KeyedOneInputStreamOperatorTestHarness<K, IN, OUT>(operator, keySelector, keyType);
        testHarness.open();
        testHarness.setProcessingTime(0L);
        testHarness.processWatermark(Long.MIN_VALUE);
        testHarness.processElement(new StreamRecord(element, 0L));
        testHarness.setProcessingTime(Long.MAX_VALUE);
        testHarness.processWatermark(Long.MAX_VALUE);
        Assert.assertTrue((testHarness.getOutput().size() >= 3 ? 1 : 0) != 0);
        testHarness.close();
    }

    private static class TestProcessAllWindowFunction
    extends ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow> {
        private TestProcessAllWindowFunction() {
        }

        public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
            for (Tuple2<String, Integer> in : values) {
                out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
            }
        }
    }

    private static class TestAllWindowFunction
    implements AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow> {
        private TestAllWindowFunction() {
        }

        public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
            for (Tuple2<String, Integer> in : values) {
                out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
            }
        }
    }

    private static class DummyRichAggregationFunction<T>
    extends RichAggregateFunction<T, T, T> {
        private DummyRichAggregationFunction() {
        }

        public T createAccumulator() {
            return null;
        }

        public T add(T value, T accumulator) {
            return accumulator;
        }

        public T getResult(T accumulator) {
            return accumulator;
        }

        public T merge(T a, T b) {
            return a;
        }
    }

    private static class DummyAggregationFunction
    implements AggregateFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private DummyAggregationFunction() {
        }

        public Tuple2<String, Integer> createAccumulator() {
            return new Tuple2((Object)"", (Object)0);
        }

        public Tuple2<String, Integer> add(Tuple2<String, Integer> value, Tuple2<String, Integer> accumulator) {
            accumulator.f0 = value.f0;
            accumulator.f1 = value.f1;
            return accumulator;
        }

        public Tuple2<String, Integer> getResult(Tuple2<String, Integer> accumulator) {
            return accumulator;
        }

        public Tuple2<String, Integer> merge(Tuple2<String, Integer> a, Tuple2<String, Integer> b) {
            return a;
        }
    }

    private static class DummyFolder
    implements FoldFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>> {
        private DummyFolder() {
        }

        public Tuple3<String, String, Integer> fold(Tuple3<String, String, Integer> accumulator, Tuple2<String, Integer> value) throws Exception {
            return accumulator;
        }
    }

    private static class DummyReducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        private DummyReducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
            return value1;
        }
    }
}

