/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.util.CollectorOutput;
import org.apache.flink.streaming.util.MockStreamTask;
import org.apache.flink.streaming.util.MockStreamTaskBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StreamSourceOperatorWatermarksTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmitMaxWatermarkForFiniteSource() throws Exception {
        StreamSource operator = new StreamSource(new FiniteSource());
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, TimeCharacteristic.EventTime, 0L);
        OperatorChain<?, ?> operatorChain = StreamSourceOperatorWatermarksTest.createOperatorChain(operator);
        try {
            operator.run(new Object(), (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class), new CollectorOutput(output), operatorChain);
        }
        finally {
            operatorChain.releaseOutputs();
        }
        Assert.assertEquals((long)1L, (long)output.size());
        Assert.assertEquals((Object)Watermark.MAX_WATERMARK, output.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoMaxWatermarkOnImmediateCancel() throws Exception {
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        StreamSource operator = new StreamSource(new InfiniteSource());
        StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, TimeCharacteristic.EventTime, 0L);
        operator.cancel();
        OperatorChain<?, ?> operatorChain = StreamSourceOperatorWatermarksTest.createOperatorChain(operator);
        try {
            operator.run(new Object(), (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class), new CollectorOutput(output), operatorChain);
        }
        finally {
            operatorChain.releaseOutputs();
        }
        Assert.assertTrue((boolean)output.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoMaxWatermarkOnAsyncCancel() throws Exception {
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        final StreamSource operator = new StreamSource(new InfiniteSource());
        StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, TimeCharacteristic.EventTime, 0L);
        new Thread("canceler"){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                operator.cancel();
            }
        }.start();
        OperatorChain<?, ?> operatorChain = StreamSourceOperatorWatermarksTest.createOperatorChain(operator);
        try {
            operator.run(new Object(), (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class), new CollectorOutput(output), operatorChain);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            operatorChain.releaseOutputs();
        }
        Assert.assertTrue((boolean)output.isEmpty());
    }

    @Test
    public void testAutomaticWatermarkContext() throws Exception {
        StreamSource operator = new StreamSource(new InfiniteSource());
        long watermarkInterval = 10L;
        TestProcessingTimeService processingTimeService = new TestProcessingTimeService();
        processingTimeService.setCurrentTime(0L);
        StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, TimeCharacteristic.IngestionTime, watermarkInterval, (ProcessingTimeService)processingTimeService);
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        StreamSourceContexts.getSourceContext((TimeCharacteristic)TimeCharacteristic.IngestionTime, (ProcessingTimeService)operator.getContainingTask().getProcessingTimeService(), (Object)operator.getContainingTask().getCheckpointLock(), (StreamStatusMaintainer)operator.getContainingTask().getStreamStatusMaintainer(), new CollectorOutput(output), (long)operator.getExecutionConfig().getAutoWatermarkInterval(), (long)-1L);
        for (long i = 1L; i < 100L; i += watermarkInterval) {
            processingTimeService.setCurrentTime(i);
        }
        Assert.assertTrue((output.size() == 9 ? 1 : 0) != 0);
        long nextWatermark = 0L;
        for (StreamElement el : output) {
            Watermark wm = (Watermark)el;
            Assert.assertTrue((wm.getTimestamp() == (nextWatermark += watermarkInterval) ? 1 : 0) != 0);
        }
    }

    private static <T> void setupSourceOperator(StreamSource<T, ?> operator, TimeCharacteristic timeChar, long watermarkInterval) throws Exception {
        StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, timeChar, watermarkInterval, (ProcessingTimeService)new TestProcessingTimeService());
    }

    private static <T> void setupSourceOperator(StreamSource<T, ?> operator, TimeCharacteristic timeChar, long watermarkInterval, ProcessingTimeService timeProvider) throws Exception {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setAutoWatermarkInterval(watermarkInterval);
        StreamConfig cfg = new StreamConfig(new Configuration());
        cfg.setStateBackend((StateBackend)new MemoryStateBackend());
        cfg.setTimeCharacteristic(timeChar);
        cfg.setOperatorID(new OperatorID());
        DummyEnvironment env = new DummyEnvironment("MockTwoInputTask", 1, 0);
        StreamStatusMaintainer streamStatusMaintainer = (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class);
        Mockito.when((Object)streamStatusMaintainer.getStreamStatus()).thenReturn((Object)StreamStatus.ACTIVE);
        MockStreamTask mockTask = new MockStreamTaskBuilder((Environment)env).setConfig(cfg).setExecutionConfig(executionConfig).setStreamStatusMaintainer(streamStatusMaintainer).setProcessingTimeService(timeProvider).build();
        operator.setup((StreamTask)mockTask, cfg, (Output)Mockito.mock(Output.class));
    }

    private static OperatorChain<?, ?> createOperatorChain(AbstractStreamOperator<?> operator) {
        return new OperatorChain(operator.getContainingTask(), StreamTask.createRecordWriters((StreamConfig)operator.getOperatorConfig(), (Environment)new MockEnvironmentBuilder().build()));
    }

    private static final class InfiniteSource<T>
    implements SourceFunction<T> {
        private volatile boolean running = true;

        private InfiniteSource() {
        }

        public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
            while (this.running) {
                Thread.sleep(20L);
            }
        }

        public void cancel() {
            this.running = false;
        }
    }

    private static final class FiniteSource<T>
    implements SourceFunction<T> {
        private FiniteSource() {
        }

        public void run(SourceFunction.SourceContext<T> ctx) {
        }

        public void cancel() {
        }
    }
}

