/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.io.BufferStorage;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.EmptyBufferStorage;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.apache.flink.streaming.runtime.io.StreamTaskNetworkInput;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StreamTaskNetworkInputTest {
    private static final int PAGE_SIZE = 1000;
    private final IOManager ioManager = new IOManagerAsync();

    @After
    public void tearDown() throws Exception {
        this.ioManager.close();
    }

    @Test
    public void testIsAvailableWithBufferedDataInDeserializer() throws Exception {
        BufferBuilder bufferBuilder = BufferBuilderTestUtils.createEmptyBufferBuilder((int)1000);
        this.serializeRecord(42L, bufferBuilder);
        this.serializeRecord(44L, bufferBuilder);
        Buffer buffer = bufferBuilder.createBufferConsumer().build();
        List<BufferOrEvent> buffers = Collections.singletonList(new BufferOrEvent(buffer, 0, false));
        StreamTaskNetworkInput input = new StreamTaskNetworkInput(new CheckpointedInputGate((InputGate)new MockInputGate(1, buffers, false), (BufferStorage)new EmptyBufferStorage(), (CheckpointBarrierHandler)new CheckpointBarrierTracker(1)), (TypeSerializer)LongSerializer.INSTANCE, this.ioManager, 0);
        StreamTaskNetworkInputTest.assertHasNextElement(input);
        StreamTaskNetworkInputTest.assertHasNextElement(input);
    }

    private void serializeRecord(long value, BufferBuilder bufferBuilder) throws IOException {
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        SerializationDelegate serializationDelegate = new SerializationDelegate((TypeSerializer)new StreamElementSerializer((TypeSerializer)LongSerializer.INSTANCE));
        serializationDelegate.setInstance((Object)new StreamRecord((Object)value));
        serializer.serializeRecord((IOReadableWritable)serializationDelegate);
        Assert.assertFalse((boolean)serializer.copyToBufferBuilder(bufferBuilder).isFullBuffer());
    }

    private static void assertHasNextElement(StreamTaskNetworkInput input) throws Exception {
        Assert.assertTrue((boolean)input.isAvailable().isDone());
        StreamElement element = input.pollNextNullable();
        Assert.assertNotNull((Object)element);
        Assert.assertTrue((boolean)element.isRecord());
    }
}

