/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.apache.flink.streaming.runtime.io.BufferStorage;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierAlignerTestBase;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class SpillingCheckpointBarrierAlignerTest
extends CheckpointBarrierAlignerTestBase {
    private static IOManager ioManager;

    @BeforeClass
    public static void setup() {
        ioManager = new IOManagerAsync();
    }

    @AfterClass
    public static void shutdownIOManager() throws Exception {
        ioManager.close();
    }

    @Override
    public void ensureEmpty() throws Exception {
        super.ensureEmpty();
        for (File dir : ioManager.getSpillingDirectories()) {
            for (String file : dir.list()) {
                if (file == null || file.equals(".") || file.equals("..")) continue;
                Assert.fail((String)("barrier buffer did not clean up temp files. remaining file: " + file));
            }
        }
    }

    @Override
    CheckpointedInputGate createBarrierBuffer(InputGate gate, @Nullable AbstractInvokable toNotify) throws IOException {
        return new CheckpointedInputGate(gate, (BufferStorage)new BufferSpiller(ioManager, 512), "Testing", toNotify);
    }

    @Override
    public void validateAlignmentBuffered(long actualBytesBuffered, BufferOrEvent ... sequence) {
        long expectedBuffered = 0L;
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer()) continue;
            expectedBuffered += (long)(9 + boe.getBuffer().getSize());
        }
        Assert.assertEquals((String)"Wrong alignment buffered bytes", (long)actualBytesBuffered, (long)expectedBuffered);
    }
}

