/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

public class MockInputGate
extends InputGate {
    private final int numberOfChannels;
    private final Queue<BufferOrEvent> bufferOrEvents;
    private final boolean[] closed;
    private final boolean finishAfterLastBuffer;

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents) {
        this(numberOfChannels, bufferOrEvents, true);
    }

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents, boolean finishAfterLastBuffer) {
        this.numberOfChannels = numberOfChannels;
        this.bufferOrEvents = new ArrayDeque<BufferOrEvent>(bufferOrEvents);
        this.closed = new boolean[numberOfChannels];
        this.finishAfterLastBuffer = finishAfterLastBuffer;
        this.isAvailable = AVAILABLE;
    }

    public void setup() {
    }

    public int getNumberOfInputChannels() {
        return this.numberOfChannels;
    }

    public boolean isFinished() {
        return this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty();
    }

    public Optional<BufferOrEvent> getNext() {
        BufferOrEvent next = this.bufferOrEvents.poll();
        if (!this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty()) {
            this.resetIsAvailable();
        }
        if (next == null) {
            return Optional.empty();
        }
        int channelIdx = next.getChannelIndex();
        if (this.closed[channelIdx]) {
            throw new RuntimeException("Inconsistent: Channel " + channelIdx + " has data even though it is already closed.");
        }
        if (next.isEvent() && next.getEvent() instanceof EndOfPartitionEvent) {
            this.closed[channelIdx] = true;
        }
        return Optional.of(next);
    }

    public Optional<BufferOrEvent> pollNext() {
        return this.getNext();
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void close() {
    }
}

