/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import junit.framework.TestCase;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.streaming.runtime.io.BufferStorage;
import org.apache.flink.streaming.runtime.io.BufferStorageTestBase;
import org.apache.flink.streaming.runtime.io.CachedBufferStorage;
import org.apache.flink.streaming.runtime.io.LinkedBufferStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedBufferStorageTest {
    private static final int PAGE_SIZE = 100;
    private CachedBufferStorage mainStorage;
    private CachedBufferStorage linkedStorage;
    private LinkedBufferStorage bufferStorage;

    @Before
    public void setUp() {
        this.mainStorage = new CachedBufferStorage(100);
        this.linkedStorage = new CachedBufferStorage(100);
        this.bufferStorage = new LinkedBufferStorage((BufferStorage)this.mainStorage, (BufferStorage)this.linkedStorage, 700L);
    }

    @After
    public void tearDown() throws IOException {
        this.bufferStorage.close();
        this.mainStorage.close();
        this.linkedStorage.close();
    }

    @Test
    public void testBasicUsage() throws IOException {
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        Assert.assertEquals((long)100L, (long)this.bufferStorage.getPendingBytes());
        Assert.assertTrue((boolean)this.bufferStorage.isEmpty());
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(101));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(102));
        Assert.assertTrue((boolean)this.bufferStorage.isEmpty());
        Assert.assertEquals((long)(this.mainStorage.getPendingBytes() + this.linkedStorage.getPendingBytes()), (long)this.bufferStorage.getPendingBytes());
        Assert.assertEquals((long)(this.mainStorage.getRolledBytes() + this.linkedStorage.getRolledBytes()), (long)this.bufferStorage.getRolledBytes());
        Assert.assertTrue((boolean)this.bufferStorage.isEmpty());
        Assert.assertTrue((boolean)this.linkedStorage.isEmpty());
        this.bufferStorage.rollOver();
        TestCase.assertFalse((boolean)this.bufferStorage.isEmpty());
        TestCase.assertFalse((boolean)this.linkedStorage.isEmpty());
        Assert.assertEquals((long)(this.mainStorage.getPendingBytes() + this.linkedStorage.getPendingBytes()), (long)this.bufferStorage.getPendingBytes());
        Assert.assertEquals((long)(this.mainStorage.getRolledBytes() + this.linkedStorage.getRolledBytes()), (long)this.bufferStorage.getRolledBytes());
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(103));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(104));
        Assert.assertEquals((long)(this.mainStorage.getPendingBytes() + this.linkedStorage.getPendingBytes()), (long)this.bufferStorage.getPendingBytes());
        Assert.assertEquals((long)(this.mainStorage.getRolledBytes() + this.linkedStorage.getRolledBytes()), (long)this.bufferStorage.getRolledBytes());
        this.bufferStorage.rollOver();
        Assert.assertEquals((long)(this.mainStorage.getPendingBytes() + this.linkedStorage.getPendingBytes()), (long)this.bufferStorage.getPendingBytes());
        Assert.assertEquals((long)(this.mainStorage.getRolledBytes() + this.linkedStorage.getRolledBytes()), (long)this.bufferStorage.getRolledBytes());
        ArrayList<Integer> bufferSizes = this.drain((BufferStorage)this.bufferStorage);
        Assert.assertEquals((long)104L, (long)bufferSizes.get(0).intValue());
        Assert.assertEquals((long)101L, (long)bufferSizes.get(1).intValue());
        Assert.assertEquals((long)102L, (long)bufferSizes.get(2).intValue());
        bufferSizes = this.drain((BufferStorage)this.linkedStorage);
        Assert.assertEquals((long)103L, (long)bufferSizes.get(0).intValue());
        Assert.assertEquals((long)100L, (long)bufferSizes.get(1).intValue());
        Assert.assertEquals((long)0L, (long)this.bufferStorage.getRolledBytes());
        Assert.assertEquals((long)0L, (long)this.bufferStorage.getPendingBytes());
    }

    @Test
    public void testPendingIsFull() throws IOException {
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        TestCase.assertFalse((boolean)this.bufferStorage.isFull());
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        Assert.assertTrue((boolean)this.bufferStorage.isFull());
    }

    public void testRolledIsFull() throws IOException {
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.rollOver();
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.rollOver();
        this.linkedStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        TestCase.assertFalse((boolean)this.bufferStorage.isFull());
        this.bufferStorage.add(BufferStorageTestBase.generateRandomBuffer(100));
        Assert.assertTrue((boolean)this.bufferStorage.isFull());
    }

    private ArrayList<Integer> drain(BufferStorage bufferStorage) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (!bufferStorage.isEmpty()) {
            Optional bufferOrEvent = bufferStorage.pollNext();
            if (!bufferOrEvent.isPresent()) continue;
            result.add(((BufferOrEvent)bufferOrEvent.get()).getSize());
        }
        return result;
    }
}

