/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.junit.Assert;

class CheckpointSequenceValidator
extends AbstractInvokable {
    private final long[] checkpointIDs;
    private int i = 0;

    CheckpointSequenceValidator(long ... checkpointIDs) {
        super((Environment)new DummyEnvironment("test", 1, 0));
        this.checkpointIDs = checkpointIDs;
    }

    public void invoke() {
        throw new UnsupportedOperationException("should never be called");
    }

    public boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) throws Exception {
        throw new UnsupportedOperationException("should never be called");
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
        Assert.assertTrue((String)("Unexpected triggerCheckpointOnBarrier(" + checkpointMetaData.getCheckpointId() + ")"), (this.i < this.checkpointIDs.length ? 1 : 0) != 0);
        long expectedId = this.checkpointIDs[this.i++];
        if (expectedId >= 0L) {
            Assert.assertEquals((String)"wrong checkpoint id", (long)expectedId, (long)checkpointMetaData.getCheckpointId());
            Assert.assertTrue((checkpointMetaData.getTimestamp() > 0L ? 1 : 0) != 0);
        } else {
            Assert.fail((String)String.format("got 'triggerCheckpointOnBarrier(%d)' when expecting an 'abortCheckpointOnBarrier(%d)'", checkpointMetaData.getCheckpointId(), expectedId));
        }
    }

    public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) {
        Assert.assertTrue((String)("Unexpected abortCheckpointOnBarrier(" + checkpointId + ")"), (this.i < this.checkpointIDs.length ? 1 : 0) != 0);
        long expectedId = this.checkpointIDs[this.i++];
        if (expectedId < 0L) {
            Assert.assertEquals((String)"wrong checkpoint id for checkpoint abort", (long)(-expectedId), (long)checkpointId);
        } else {
            Assert.fail((String)String.format("got 'abortCheckpointOnBarrier(%d)' when expecting an 'triggerCheckpointOnBarrier(%d)'", checkpointId, expectedId));
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        throw new UnsupportedOperationException("should never be called");
    }
}

