/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.BufferStorage;
import org.apache.flink.streaming.runtime.io.CachedBufferStorage;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointSequenceValidator;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointBarrierTrackerTest {
    private static final int PAGE_SIZE = 512;
    private CheckpointedInputGate inputGate;

    @After
    public void ensureEmpty() throws Exception {
        Assert.assertFalse((boolean)this.inputGate.pollNext().isPresent());
        Assert.assertTrue((boolean)this.inputGate.isFinished());
        Assert.assertTrue((boolean)this.inputGate.isEmpty());
    }

    @Test
    public void testSingleChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0)};
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(1, sequence);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testMultiChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(3), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2)};
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(4, sequence);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testSingleChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createBarrier(3L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBarrier(5L, 0), CheckpointBarrierTrackerTest.createBarrier(6L, 0), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, 2L, 3L, 4L, 5L, 6L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(1, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testSingleChannelWithSkippedBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(3L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBarrier(6L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(7L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(10L, 0), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, 3L, 4L, 6L, 7L, 10L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(1, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testMultiChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 1), CheckpointBarrierTrackerTest.createBarrier(1L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createBarrier(2L, 1), CheckpointBarrierTrackerTest.createBarrier(2L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(3L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(3L, 0), CheckpointBarrierTrackerTest.createBarrier(3L, 1), CheckpointBarrierTrackerTest.createBarrier(4L, 1), CheckpointBarrierTrackerTest.createBarrier(4L, 2), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, 2L, 3L, 4L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(3, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testMultiChannelSkippingCheckpoints() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 1), CheckpointBarrierTrackerTest.createBarrier(1L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createBarrier(2L, 1), CheckpointBarrierTrackerTest.createBarrier(2L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(3L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(4L, 1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(4L, 2), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, 2L, 4L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(3, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testCompleteCheckpointsOnLateBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(2L, 1), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createBarrier(2L, 2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(3L, 1), CheckpointBarrierTrackerTest.createBarrier(3L, 2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(4L, 2), CheckpointBarrierTrackerTest.createBarrier(4L, 1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(3L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(5L, 1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(5L, 0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(5L, 2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(6L, 1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(6L, 0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(7L, 1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(7L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(8L, 2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(8L, 1), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(9L, 1), CheckpointBarrierTrackerTest.createBarrier(7L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(9L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(10L, 2), CheckpointBarrierTrackerTest.createBarrier(8L, 0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(9L, 0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(10L, 0), CheckpointBarrierTrackerTest.createBarrier(10L, 1)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(2L, 3L, 4L, 5L, 7L, 8L, 9L, 10L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(3, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testSingleChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createCancellationBarrier(4L, 0), CheckpointBarrierTrackerTest.createBarrier(5L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createCancellationBarrier(6L, 0), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, 2L, -4L, 5L, -6L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(1, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (boe.isBuffer()) {
                Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
            }
            Assert.assertTrue((boolean)this.inputGate.isEmpty());
        }
    }

    @Test
    public void testMultiChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(1L, 1), CheckpointBarrierTrackerTest.createBarrier(1L, 2), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(2L, 0), CheckpointBarrierTrackerTest.createBarrier(2L, 2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createCancellationBarrier(2L, 1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBarrier(3L, 1), CheckpointBarrierTrackerTest.createBarrier(3L, 2), CheckpointBarrierTrackerTest.createBarrier(3L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createCancellationBarrier(4L, 1), CheckpointBarrierTrackerTest.createBarrier(4L, 2), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBarrier(4L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createBuffer(2), CheckpointBarrierTrackerTest.createBarrier(5L, 2), CheckpointBarrierTrackerTest.createBarrier(5L, 1), CheckpointBarrierTrackerTest.createBarrier(5L, 0), CheckpointBarrierTrackerTest.createBuffer(0), CheckpointBarrierTrackerTest.createBuffer(1), CheckpointBarrierTrackerTest.createCancellationBarrier(6L, 1), CheckpointBarrierTrackerTest.createCancellationBarrier(6L, 2), CheckpointBarrierTrackerTest.createBarrier(6L, 0), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(1L, -2L, 3L, -4L, 5L, -6L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(3, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer()) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testInterleavedCancellationBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierTrackerTest.createBarrier(1L, 0), CheckpointBarrierTrackerTest.createCancellationBarrier(2L, 0), CheckpointBarrierTrackerTest.createCancellationBarrier(1L, 1), CheckpointBarrierTrackerTest.createCancellationBarrier(2L, 1), CheckpointBarrierTrackerTest.createCancellationBarrier(1L, 2), CheckpointBarrierTrackerTest.createCancellationBarrier(2L, 2), CheckpointBarrierTrackerTest.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(-1L, -2L);
        this.inputGate = CheckpointBarrierTrackerTest.createBarrierTracker(3, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && (boe.getEvent().getClass() == CheckpointBarrier.class || boe.getEvent().getClass() == CancelCheckpointMarker.class)) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    private static CheckpointedInputGate createBarrierTracker(int numberOfChannels, BufferOrEvent[] sequence) {
        return CheckpointBarrierTrackerTest.createBarrierTracker(numberOfChannels, sequence, null);
    }

    private static CheckpointedInputGate createBarrierTracker(int numberOfChannels, BufferOrEvent[] sequence, @Nullable AbstractInvokable toNotifyOnCheckpoint) {
        MockInputGate gate = new MockInputGate(numberOfChannels, Arrays.asList(sequence));
        return new CheckpointedInputGate((InputGate)gate, (BufferStorage)new CachedBufferStorage(512, -1L, "Testing"), (CheckpointBarrierHandler)new CheckpointBarrierTracker(gate.getNumberOfInputChannels(), toNotifyOnCheckpoint));
    }

    private static BufferOrEvent createBarrier(long id, int channel) {
        return new BufferOrEvent((AbstractEvent)new CheckpointBarrier(id, System.currentTimeMillis(), CheckpointOptions.forCheckpointWithDefaultLocation()), channel);
    }

    private static BufferOrEvent createCancellationBarrier(long id, int channel) {
        return new BufferOrEvent((AbstractEvent)new CancelCheckpointMarker(id), channel);
    }

    private static BufferOrEvent createBuffer(int channel) {
        return new BufferOrEvent((Buffer)new NetworkBuffer(MemorySegmentFactory.wrap((byte[])new byte[]{1, 2}), FreeingBufferRecycler.INSTANCE), channel);
    }
}

