/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.streaming.runtime.io.CheckpointSequenceValidator;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public abstract class CheckpointBarrierAlignerTestBase {
    protected static final int PAGE_SIZE = 512;
    private static final Random RND = new Random();
    private static int sizeCounter = 1;
    CheckpointedInputGate inputGate;

    protected CheckpointedInputGate createBarrierBuffer(int numberOfChannels, BufferOrEvent[] sequence, @Nullable AbstractInvokable toNotify) throws IOException {
        MockInputGate gate = new MockInputGate(numberOfChannels, Arrays.asList(sequence));
        return this.createBarrierBuffer(gate, toNotify);
    }

    protected CheckpointedInputGate createBarrierBuffer(int numberOfChannels, BufferOrEvent[] sequence) throws IOException {
        return this.createBarrierBuffer(numberOfChannels, sequence, null);
    }

    protected CheckpointedInputGate createBarrierBuffer(InputGate gate) throws IOException {
        return this.createBarrierBuffer(gate, null);
    }

    abstract CheckpointedInputGate createBarrierBuffer(InputGate var1, @Nullable AbstractInvokable var2) throws IOException;

    abstract void validateAlignmentBuffered(long var1, BufferOrEvent ... var3);

    @After
    public void ensureEmpty() throws Exception {
        Assert.assertFalse((boolean)this.inputGate.pollNext().isPresent());
        Assert.assertTrue((boolean)this.inputGate.isFinished());
        Assert.assertTrue((boolean)this.inputGate.isEmpty());
        this.inputGate.cleanup();
    }

    @Test
    public void testSingleChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        this.inputGate = this.createBarrierBuffer(1, sequence);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
    }

    @Test
    public void testMultiChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(3), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2)};
        this.inputGate = this.createBarrierBuffer(4, sequence);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
    }

    @Test
    public void testSingleChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBarrier(5L, 0), CheckpointBarrierAlignerTestBase.createBarrier(6L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(1, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testMultiChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBarrier(4L, 1), CheckpointBarrierAlignerTestBase.createBarrier(4L, 2), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(5L, 1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(5L, 2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(5L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(2)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(3, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[5], sequence[6]);
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[17], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)3L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), new BufferOrEvent[0]);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[20], sequence[21]);
        Assert.assertEquals((long)4L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[27], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), new BufferOrEvent[0]);
        Assert.assertEquals((long)5L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[28], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[29], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[31], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[32], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[33], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[37], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[34], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[36], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[38], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[39], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[41], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[42], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[43], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[44], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[34], sequence[36], sequence[38], sequence[39]);
    }

    @Test
    public void testMultiChannelTrailingBlockedData() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(3, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[14], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[17], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testMultiChannelWithQueuedFutureBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(4L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(5L, 1), CheckpointBarrierAlignerTestBase.createBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(6L, 1), CheckpointBarrierAlignerTestBase.createBarrier(4L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(3, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[23], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[25], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[27], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[30], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[32], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[28], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[36], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[38], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[22], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[26], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[31], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[33], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[39], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[42], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[45], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[46], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[37], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[47], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[48], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[43], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[44], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testMultiChannelSkippingCheckpoints() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(3, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)3L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED)));
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)3L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_INPUT_END_OF_STREAM)));
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[22], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[23], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[24], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testMultiChannelJumpingOverCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(3, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)4L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[22], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[25], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[26], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[24], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[27], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[28], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[29], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[30], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testMultiChannelSkippingCheckpointsViaBlockedInputs() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(4L, 2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        this.inputGate = this.createBarrierBuffer(3, sequence);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[22], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)4L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[24], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[26], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[30], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[28], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[29], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[32], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[33], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[34], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[35], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[36], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[37], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testMissingCancellationBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBuffer(0)};
        CheckpointSequenceValidator validator = new CheckpointSequenceValidator(-3L);
        this.inputGate = this.createBarrierBuffer(2, sequence, validator);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && (boe.getEvent().getClass() == CheckpointBarrier.class || boe.getEvent().getClass() == CancelCheckpointMarker.class)) continue;
            Assert.assertEquals((Object)boe, this.inputGate.pollNext().get());
        }
    }

    @Test
    public void testEarlyCleanup() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        this.inputGate = this.createBarrierBuffer(3, sequence, handler);
        handler.setNextExpectedCheckpointId(1L);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[14], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        this.inputGate.pollNext().get();
        this.inputGate.pollNext().get();
        this.inputGate.pollNext().get();
        this.inputGate.pollNext().get();
        this.inputGate.pollNext().get();
    }

    @Test
    public void testStartAlignmentWithClosedChannels() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createBarrier(2L, 3), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 3), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 3), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createEndOfPartition(0), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createBarrier(5L, 3), CheckpointBarrierAlignerTestBase.createBuffer(3), CheckpointBarrierAlignerTestBase.createEndOfPartition(3)};
        this.inputGate = this.createBarrierBuffer(4, sequence);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[3], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[4], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)3L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)4L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[17], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)5L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[22], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testEndOfStreamWhileCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createEndOfPartition(2), CheckpointBarrierAlignerTestBase.createEndOfPartition(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createEndOfPartition(0)};
        this.inputGate = this.createBarrierBuffer(3, sequence);
        CheckpointBarrierAlignerTestBase.check(sequence[3], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[4], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)1L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)2L, (long)this.inputGate.getLatestCheckpointId());
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[14], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
    }

    @Test
    public void testSingleChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBarrier(5L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(6L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(1, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)5L, (long)this.inputGate.getLatestCheckpointId());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(2L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)4L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)6L, (long)this.inputGate.getLatestCheckpointId());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)6L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
    }

    @Test
    public void testMultiChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createCancellationBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createCancellationBarrier(4L, 1), CheckpointBarrierAlignerTestBase.createBarrier(4L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(4L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(5L, 2), CheckpointBarrierAlignerTestBase.createBarrier(5L, 1), CheckpointBarrierAlignerTestBase.createBarrier(5L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createCancellationBarrier(6L, 1), CheckpointBarrierAlignerTestBase.createCancellationBarrier(6L, 2), CheckpointBarrierAlignerTestBase.createBarrier(6L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(3, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[1], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(3L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[21], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[24], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)4L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[26], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[27], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[28], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[32], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[33], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[37], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)6L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
    }

    @Test
    public void testAbortViaQueuedBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createCancellationBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(3, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[4], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[3], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[14], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[17], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        Assert.assertEquals((long)0L, (long)this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
    }

    @Test
    public void testAbortWhileHavingQueuedBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(1L, 1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(2L, 1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createCancellationBarrier(1L, 0), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBarrier(1L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(2L, 0), CheckpointBarrierAlignerTestBase.createBarrier(2L, 2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(3, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[2], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[3], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[6], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[4], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)1L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[15], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(2L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.check(sequence[10], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[14], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[19], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[20], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testIgnoreCancelBarrierIfCheckpointSubsumed() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(3L, 1), CheckpointBarrierAlignerTestBase.createBarrier(3L, 0), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBarrier(5L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createCancellationBarrier(3L, 2), CheckpointBarrierAlignerTestBase.createBuffer(2), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBarrier(5L, 0), CheckpointBarrierAlignerTestBase.createBarrier(5L, 1), CheckpointBarrierAlignerTestBase.createBuffer(0), CheckpointBarrierAlignerTestBase.createBuffer(1), CheckpointBarrierAlignerTestBase.createBuffer(2)};
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.inputGate = this.createBarrierBuffer(3, sequence, toNotify);
        CheckpointBarrierAlignerTestBase.check(sequence[0], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[5], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        long startTs = System.nanoTime();
        CheckpointBarrierAlignerTestBase.check(sequence[3], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)3L), (Throwable)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED)));
        CheckpointBarrierAlignerTestBase.check(sequence[4], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[8], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[9], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[12], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[13], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[7], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.validateAlignmentTime(startTs, this.inputGate.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        CheckpointBarrierAlignerTestBase.check(sequence[11], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[16], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[17], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        CheckpointBarrierAlignerTestBase.check(sequence[18], (BufferOrEvent)this.inputGate.pollNext().get(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)Matchers.any(Throwable.class));
    }

    private static BufferOrEvent createBarrier(long checkpointId, int channel) {
        return new BufferOrEvent((AbstractEvent)new CheckpointBarrier(checkpointId, System.currentTimeMillis(), CheckpointOptions.forCheckpointWithDefaultLocation()), channel);
    }

    private static BufferOrEvent createCancellationBarrier(long checkpointId, int channel) {
        return new BufferOrEvent((AbstractEvent)new CancelCheckpointMarker(checkpointId), channel);
    }

    private static BufferOrEvent createBuffer(int channel) {
        int size = sizeCounter++;
        byte[] bytes = new byte[size];
        RND.nextBytes(bytes);
        MemorySegment memory = MemorySegmentFactory.allocateUnpooledSegment((int)512);
        memory.put(0, bytes);
        NetworkBuffer buf = new NetworkBuffer(memory, FreeingBufferRecycler.INSTANCE);
        buf.setSize(size);
        buf.retainBuffer();
        return new BufferOrEvent((Buffer)buf, channel);
    }

    private static BufferOrEvent createEndOfPartition(int channel) {
        return new BufferOrEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE, channel);
    }

    private static void check(BufferOrEvent expected, BufferOrEvent present, int pageSize) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)present);
        Assert.assertEquals((Object)expected.isBuffer(), (Object)present.isBuffer());
        if (expected.isBuffer()) {
            Assert.assertEquals((long)expected.getBuffer().getMaxCapacity(), (long)present.getBuffer().getMaxCapacity());
            Assert.assertEquals((long)expected.getBuffer().getSize(), (long)present.getBuffer().getSize());
            MemorySegment expectedMem = expected.getBuffer().getMemorySegment();
            MemorySegment presentMem = present.getBuffer().getMemorySegment();
            Assert.assertTrue((String)"memory contents differs", (expectedMem.compare(presentMem, 0, 0, pageSize) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)expected.getEvent(), (Object)present.getEvent());
        }
    }

    private static void validateAlignmentTime(long startTimestamp, long alignmentDuration) {
        long elapsed = System.nanoTime() - startTimestamp;
        Assert.assertTrue((String)"wrong alignment time", (alignmentDuration <= elapsed ? 1 : 0) != 0);
    }

    public static class CheckpointExceptionMatcher
    extends BaseMatcher<CheckpointException> {
        private final CheckpointFailureReason failureReason;

        public CheckpointExceptionMatcher(CheckpointFailureReason failureReason) {
            this.failureReason = failureReason;
        }

        public boolean matches(Object o) {
            return o != null && o.getClass() == CheckpointException.class && ((CheckpointException)o).getCheckpointFailureReason().equals((Object)this.failureReason);
        }

        public void describeTo(Description description) {
            description.appendText("CheckpointException - reason = " + this.failureReason);
        }
    }

    private static class CheckpointMatcher
    extends BaseMatcher<CheckpointMetaData> {
        private final long checkpointId;

        CheckpointMatcher(long checkpointId) {
            this.checkpointId = checkpointId;
        }

        public boolean matches(Object o) {
            return o != null && o.getClass() == CheckpointMetaData.class && ((CheckpointMetaData)o).getCheckpointId() == this.checkpointId;
        }

        public void describeTo(Description description) {
            description.appendText("CheckpointMetaData - id = " + this.checkpointId);
        }
    }

    private static class ValidatingCheckpointHandler
    extends AbstractInvokable {
        private long nextExpectedCheckpointId = -1L;
        private long lastReportedBytesBufferedInAlignment = -1L;

        public ValidatingCheckpointHandler() {
            super((Environment)new DummyEnvironment("test", 1, 0));
        }

        public void setNextExpectedCheckpointId(long nextExpectedCheckpointId) {
            this.nextExpectedCheckpointId = nextExpectedCheckpointId;
        }

        public long getNextExpectedCheckpointId() {
            return this.nextExpectedCheckpointId;
        }

        long getLastReportedBytesBufferedInAlignment() {
            return this.lastReportedBytesBufferedInAlignment;
        }

        public void invoke() {
            throw new UnsupportedOperationException();
        }

        public boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) throws Exception {
            throw new UnsupportedOperationException("should never be called");
        }

        public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
            Assert.assertTrue((String)"wrong checkpoint id", (this.nextExpectedCheckpointId == -1L || this.nextExpectedCheckpointId == checkpointMetaData.getCheckpointId() ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetaData.getTimestamp() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetrics.getBytesBufferedInAlignment() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetrics.getAlignmentDurationNanos() >= 0L ? 1 : 0) != 0);
            ++this.nextExpectedCheckpointId;
            this.lastReportedBytesBufferedInAlignment = checkpointMetrics.getBytesBufferedInAlignment();
        }

        public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) {
        }

        public void notifyCheckpointComplete(long checkpointId) throws Exception {
            throw new UnsupportedOperationException("should never be called");
        }
    }
}

