/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class OperatorSnapshotFuturesTest
extends TestLogger {
    @Test
    public void testCancelAndCleanup() throws Exception {
        OperatorSnapshotFutures operatorSnapshotResult = new OperatorSnapshotFutures();
        operatorSnapshotResult.cancel();
        KeyedStateHandle keyedManagedStateHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        SnapshotResult keyedStateManagedResult = SnapshotResult.of((StateObject)keyedManagedStateHandle);
        RunnableFuture keyedStateManagedFuture = (RunnableFuture)PowerMockito.spy((Object)DoneFuture.of((Object)keyedStateManagedResult));
        KeyedStateHandle keyedRawStateHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        SnapshotResult keyedStateRawResult = SnapshotResult.of((StateObject)keyedRawStateHandle);
        RunnableFuture keyedStateRawFuture = (RunnableFuture)PowerMockito.spy((Object)DoneFuture.of((Object)keyedStateRawResult));
        OperatorStateHandle operatorManagedStateHandle = (OperatorStateHandle)Mockito.mock(OperatorStreamStateHandle.class);
        SnapshotResult operatorStateManagedResult = SnapshotResult.of((StateObject)operatorManagedStateHandle);
        RunnableFuture operatorStateManagedFuture = (RunnableFuture)PowerMockito.spy((Object)DoneFuture.of((Object)operatorStateManagedResult));
        OperatorStateHandle operatorRawStateHandle = (OperatorStateHandle)Mockito.mock(OperatorStreamStateHandle.class);
        SnapshotResult operatorStateRawResult = SnapshotResult.of((StateObject)operatorRawStateHandle);
        RunnableFuture operatorStateRawFuture = (RunnableFuture)PowerMockito.spy((Object)DoneFuture.of((Object)operatorStateRawResult));
        operatorSnapshotResult = new OperatorSnapshotFutures(keyedStateManagedFuture, keyedStateRawFuture, operatorStateManagedFuture, operatorStateRawFuture);
        operatorSnapshotResult.cancel();
        ((RunnableFuture)Mockito.verify((Object)keyedStateManagedFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)keyedStateRawFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)operatorStateManagedFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)operatorStateRawFuture)).cancel(true);
        ((KeyedStateHandle)Mockito.verify((Object)keyedManagedStateHandle)).discardState();
        ((KeyedStateHandle)Mockito.verify((Object)keyedRawStateHandle)).discardState();
        ((OperatorStateHandle)Mockito.verify((Object)operatorManagedStateHandle)).discardState();
        ((OperatorStateHandle)Mockito.verify((Object)operatorRawStateHandle)).discardState();
    }
}

