/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Random;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFinalizer;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class OperatorSnapshotFinalizerTest
extends TestLogger {
    @Test
    public void testRunAndExtract() throws Exception {
        Random random = new Random(66L);
        KeyedStateHandle keyedTemplate = StateHandleDummyUtil.createNewKeyedStateHandle((KeyGroupRange)new KeyGroupRange(0, 0));
        OperatorStateHandle operatorTemplate = StateHandleDummyUtil.createNewOperatorStateHandle((int)2, (Random)random);
        SnapshotResult snapKeyMan = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)keyedTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)keyedTemplate));
        SnapshotResult snapKeyRaw = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)keyedTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)keyedTemplate));
        SnapshotResult snapOpMan = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)operatorTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)operatorTemplate));
        SnapshotResult snapOpRaw = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)operatorTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)operatorTemplate));
        PseudoNotDoneFuture<SnapshotResult> managedKeyed = new PseudoNotDoneFuture<SnapshotResult>(snapKeyMan);
        PseudoNotDoneFuture<SnapshotResult> rawKeyed = new PseudoNotDoneFuture<SnapshotResult>(snapKeyRaw);
        PseudoNotDoneFuture<SnapshotResult> managedOp = new PseudoNotDoneFuture<SnapshotResult>(snapOpMan);
        PseudoNotDoneFuture<SnapshotResult> rawOp = new PseudoNotDoneFuture<SnapshotResult>(snapOpRaw);
        Assert.assertFalse((boolean)managedKeyed.isDone());
        Assert.assertFalse((boolean)rawKeyed.isDone());
        Assert.assertFalse((boolean)managedOp.isDone());
        Assert.assertFalse((boolean)rawOp.isDone());
        OperatorSnapshotFutures futures = new OperatorSnapshotFutures(managedKeyed, rawKeyed, managedOp, rawOp);
        OperatorSnapshotFinalizer operatorSnapshotFinalizer = new OperatorSnapshotFinalizer(futures);
        Assert.assertTrue((boolean)managedKeyed.isDone());
        Assert.assertTrue((boolean)rawKeyed.isDone());
        Assert.assertTrue((boolean)managedOp.isDone());
        Assert.assertTrue((boolean)rawOp.isDone());
        OperatorSubtaskState jobManagerOwnedState = operatorSnapshotFinalizer.getJobManagerOwnedState();
        Assert.assertTrue((boolean)this.checkResult(snapKeyMan.getJobManagerOwnedSnapshot(), jobManagerOwnedState.getManagedKeyedState()));
        Assert.assertTrue((boolean)this.checkResult(snapKeyRaw.getJobManagerOwnedSnapshot(), jobManagerOwnedState.getRawKeyedState()));
        Assert.assertTrue((boolean)this.checkResult(snapOpMan.getJobManagerOwnedSnapshot(), jobManagerOwnedState.getManagedOperatorState()));
        Assert.assertTrue((boolean)this.checkResult(snapOpRaw.getJobManagerOwnedSnapshot(), jobManagerOwnedState.getRawOperatorState()));
        OperatorSubtaskState taskLocalState = operatorSnapshotFinalizer.getTaskLocalState();
        Assert.assertTrue((boolean)this.checkResult(snapKeyMan.getTaskLocalSnapshot(), taskLocalState.getManagedKeyedState()));
        Assert.assertTrue((boolean)this.checkResult(snapKeyRaw.getTaskLocalSnapshot(), taskLocalState.getRawKeyedState()));
        Assert.assertTrue((boolean)this.checkResult(snapOpMan.getTaskLocalSnapshot(), taskLocalState.getManagedOperatorState()));
        Assert.assertTrue((boolean)this.checkResult(snapOpRaw.getTaskLocalSnapshot(), taskLocalState.getRawOperatorState()));
    }

    private <T extends StateObject> boolean checkResult(T expected, StateObjectCollection<T> actual) {
        if (expected == null) {
            return actual.isEmpty();
        }
        return actual.size() == 1 && expected == actual.iterator().next();
    }

    static class PseudoNotDoneFuture<T>
    extends DoneFuture<T> {
        private boolean done = false;

        PseudoNotDoneFuture(T payload) {
            super(payload);
        }

        public void run() {
            super.run();
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

