/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.streaming.api.operators.InputSelection;
import org.junit.Assert;
import org.junit.Test;

public class InputSelectionTest {
    @Test
    public void testIsInputSelected() {
        Assert.assertFalse((boolean)new InputSelection.Builder().build().isInputSelected(1));
        Assert.assertFalse((boolean)new InputSelection.Builder().select(2).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).select(2).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(-1).build().isInputSelected(1));
        Assert.assertTrue((boolean)new InputSelection.Builder().select(64).build().isInputSelected(64));
    }

    @Test
    public void testIsALLMaskOf2() {
        Assert.assertTrue((boolean)InputSelection.ALL.isALLMaskOf2());
        Assert.assertTrue((boolean)new InputSelection.Builder().select(1).select(2).build().isALLMaskOf2());
        Assert.assertFalse((boolean)InputSelection.FIRST.isALLMaskOf2());
        Assert.assertFalse((boolean)InputSelection.SECOND.isALLMaskOf2());
        Assert.assertFalse((boolean)new InputSelection.Builder().select(3).build().isALLMaskOf2());
    }

    @Test
    public void testFairSelectNextIndexOutOf2() {
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(3, 0));
        Assert.assertEquals((long)0L, (long)new InputSelection.Builder().select(1).select(2).build().fairSelectNextIndexOutOf2(3, 1));
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 0));
        Assert.assertEquals((long)1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 1));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 0));
        Assert.assertEquals((long)0L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 1));
        Assert.assertEquals((long)0L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(1, 0));
        Assert.assertEquals((long)0L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(3, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(2, 0));
        Assert.assertEquals((long)-1L, (long)InputSelection.FIRST.fairSelectNextIndexOutOf2(0, 0));
        Assert.assertEquals((long)1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(2, 1));
        Assert.assertEquals((long)1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(3, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(1, 1));
        Assert.assertEquals((long)-1L, (long)InputSelection.SECOND.fairSelectNextIndexOutOf2(0, 1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedFairSelectNextIndexOutOf2() {
        InputSelection.ALL.fairSelectNextIndexOutOf2(7, 0);
    }

    public static class BuilderTest {
        @Test
        public void testSelect() {
            Assert.assertEquals((long)1L, (long)new InputSelection.Builder().select(1).build().getInputMask());
            Assert.assertEquals((long)7L, (long)new InputSelection.Builder().select(1).select(2).select(3).build().getInputMask());
            Assert.assertEquals((long)Long.MIN_VALUE, (long)new InputSelection.Builder().select(64).build().getInputMask());
            Assert.assertEquals((long)-1L, (long)new InputSelection.Builder().select(-1).build().getInputMask());
        }

        @Test(expected=IllegalArgumentException.class)
        public void testIllegalInputId1() {
            new InputSelection.Builder().select(-2);
        }

        @Test(expected=IllegalArgumentException.class)
        public void testIllegalInputId2() {
            new InputSelection.Builder().select(65);
        }
    }
}

