/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.async;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RichAsyncFunctionTest {
    @Test
    public void testIterationRuntimeContext() throws Exception {
        RichAsyncFunction<Integer, Integer> function = new RichAsyncFunction<Integer, Integer>(){
            private static final long serialVersionUID = -2023923961609455894L;

            public void asyncInvoke(Integer input, ResultFuture<Integer> resultFuture) throws Exception {
            }
        };
        int superstepNumber = 42;
        IterationRuntimeContext mockedIterationRuntimeContext = (IterationRuntimeContext)Mockito.mock(IterationRuntimeContext.class);
        Mockito.when((Object)mockedIterationRuntimeContext.getSuperstepNumber()).thenReturn((Object)superstepNumber);
        function.setRuntimeContext((RuntimeContext)mockedIterationRuntimeContext);
        IterationRuntimeContext iterationRuntimeContext = function.getIterationRuntimeContext();
        Assert.assertEquals((long)superstepNumber, (long)iterationRuntimeContext.getSuperstepNumber());
        try {
            iterationRuntimeContext.getIterationAggregator("foobar");
            Assert.fail((String)"Expected getIterationAggregator to fail with unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            iterationRuntimeContext.getPreviousIterationAggregate("foobar");
            Assert.fail((String)"Expected getPreviousIterationAggregator to fail with unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRuntimeContext() throws Exception {
        RichAsyncFunction<Integer, Integer> function = new RichAsyncFunction<Integer, Integer>(){
            private static final long serialVersionUID = 1707630162838967972L;

            public void asyncInvoke(Integer input, ResultFuture<Integer> resultFuture) throws Exception {
            }
        };
        String taskName = "foobarTask";
        UnregisteredMetricsGroup metricGroup = new UnregisteredMetricsGroup();
        int numberOfParallelSubtasks = 42;
        int indexOfSubtask = 43;
        int attemptNumber = 1337;
        String taskNameWithSubtask = "barfoo";
        ExecutionConfig executionConfig = (ExecutionConfig)Mockito.mock(ExecutionConfig.class);
        ClassLoader userCodeClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        RuntimeContext mockedRuntimeContext = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        Mockito.when((Object)mockedRuntimeContext.getTaskName()).thenReturn((Object)"foobarTask");
        Mockito.when((Object)mockedRuntimeContext.getMetricGroup()).thenReturn((Object)metricGroup);
        Mockito.when((Object)mockedRuntimeContext.getNumberOfParallelSubtasks()).thenReturn((Object)42);
        Mockito.when((Object)mockedRuntimeContext.getIndexOfThisSubtask()).thenReturn((Object)43);
        Mockito.when((Object)mockedRuntimeContext.getAttemptNumber()).thenReturn((Object)1337);
        Mockito.when((Object)mockedRuntimeContext.getTaskNameWithSubtasks()).thenReturn((Object)"barfoo");
        Mockito.when((Object)mockedRuntimeContext.getExecutionConfig()).thenReturn((Object)executionConfig);
        Mockito.when((Object)mockedRuntimeContext.getUserCodeClassLoader()).thenReturn((Object)userCodeClassLoader);
        function.setRuntimeContext(mockedRuntimeContext);
        RuntimeContext runtimeContext = function.getRuntimeContext();
        Assert.assertEquals((Object)"foobarTask", (Object)runtimeContext.getTaskName());
        Assert.assertEquals((Object)metricGroup, (Object)runtimeContext.getMetricGroup());
        Assert.assertEquals((long)42L, (long)runtimeContext.getNumberOfParallelSubtasks());
        Assert.assertEquals((long)43L, (long)runtimeContext.getIndexOfThisSubtask());
        Assert.assertEquals((long)1337L, (long)runtimeContext.getAttemptNumber());
        Assert.assertEquals((Object)"barfoo", (Object)runtimeContext.getTaskNameWithSubtasks());
        Assert.assertEquals((Object)executionConfig, (Object)runtimeContext.getExecutionConfig());
        Assert.assertEquals((Object)userCodeClassLoader, (Object)runtimeContext.getUserCodeClassLoader());
        try {
            runtimeContext.getDistributedCache();
            Assert.fail((String)"Expected getDistributedCached to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getState(new ValueStateDescriptor("foobar", Integer.class, (Object)42));
            Assert.fail((String)"Expected getState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getListState(new ListStateDescriptor("foobar", Integer.class));
            Assert.fail((String)"Expected getListState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getReducingState(new ReducingStateDescriptor("foobar", (ReduceFunction)new ReduceFunction<Integer>(){
                private static final long serialVersionUID = 2136425961884441050L;

                public Integer reduce(Integer value1, Integer value2) throws Exception {
                    return value1;
                }
            }, Integer.class));
            Assert.fail((String)"Expected getReducingState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getAggregatingState(new AggregatingStateDescriptor("foobar", (AggregateFunction)new AggregateFunction<Integer, Integer, Integer>(){

                public Integer createAccumulator() {
                    return null;
                }

                public Integer add(Integer value, Integer accumulator) {
                    return null;
                }

                public Integer getResult(Integer accumulator) {
                    return null;
                }

                public Integer merge(Integer a, Integer b) {
                    return null;
                }
            }, Integer.class));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getFoldingState(new FoldingStateDescriptor("foobar", (Object)0, (FoldFunction)new FoldFunction<Integer, Integer>(){

                public Integer fold(Integer accumulator, Integer value) throws Exception {
                    return accumulator;
                }
            }, Integer.class));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getMapState(new MapStateDescriptor("foobar", Integer.class, String.class));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.addAccumulator("foobar", (Accumulator)new Accumulator<Integer, Integer>(){
                private static final long serialVersionUID = -4673320336846482358L;

                public void add(Integer value) {
                }

                public Integer getLocalValue() {
                    return null;
                }

                public void resetLocal() {
                }

                public void merge(Accumulator<Integer, Integer> other) {
                }

                public Accumulator<Integer, Integer> clone() {
                    return null;
                }
            });
            Assert.fail((String)"Expected addAccumulator to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getAccumulator("foobar");
            Assert.fail((String)"Expected getAccumulator to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getAllAccumulators();
            Assert.fail((String)"Expected getAllAccumulators to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getIntCounter("foobar");
            Assert.fail((String)"Expected getIntCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getLongCounter("foobar");
            Assert.fail((String)"Expected getLongCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getDoubleCounter("foobar");
            Assert.fail((String)"Expected getDoubleCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getHistogram("foobar");
            Assert.fail((String)"Expected getHistogram to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.hasBroadcastVariable("foobar");
            Assert.fail((String)"Expected hasBroadcastVariable to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getBroadcastVariable("foobar");
            Assert.fail((String)"Expected getBroadcastVariable to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getBroadcastVariableWithInitializer("foobar", (BroadcastVariableInitializer)new BroadcastVariableInitializer<Object, Object>(){

                public Object initializeBroadcastVariable(Iterable<Object> data) {
                    return null;
                }
            });
            Assert.fail((String)"Expected getBroadcastVariableWithInitializer to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

