/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.IngestionTimeExtractor;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.junit.Assert;
import org.junit.Test;

public class IngestionTimeExtractorTest {
    @Test
    public void testMonotonousTimestamps() {
        IngestionTimeExtractor assigner = new IngestionTimeExtractor();
        long maxRecordSoFar = 0L;
        long maxWatermarkSoFar = 0L;
        for (int i = 0; i < 1343; ++i) {
            if (i % 7 == 1) {
                Watermark mark = assigner.getCurrentWatermark();
                Assert.assertNotNull((Object)mark);
                Assert.assertTrue((mark.getTimestamp() >= maxWatermarkSoFar ? 1 : 0) != 0);
                maxWatermarkSoFar = mark.getTimestamp();
                Assert.assertTrue((mark.getTimestamp() >= maxRecordSoFar - 1L ? 1 : 0) != 0);
            } else {
                long next = assigner.extractTimestamp((Object)"a", Long.MIN_VALUE);
                Assert.assertTrue((next >= maxRecordSoFar ? 1 : 0) != 0);
                Assert.assertTrue((next > maxWatermarkSoFar ? 1 : 0) != 0);
                maxRecordSoFar = next;
            }
            if (i % 9 != 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

