/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RemoteStreamEnvironment.class})
public class RemoteStreamExecutionEnvironmentTest
extends TestLogger {
    @Test
    public void testPortForwarding() throws Exception {
        String host = "fakeHost";
        int port = 99;
        JobExecutionResult expectedResult = new JobExecutionResult(null, 0L, null);
        RestClusterClient mockedClient = (RestClusterClient)Mockito.mock(RestClusterClient.class);
        Mockito.when((Object)mockedClient.run((FlinkPlan)Mockito.any(), (List)Mockito.any(), (List)Mockito.any(), (ClassLoader)Mockito.any(), (SavepointRestoreSettings)Mockito.any())).thenReturn((Object)expectedResult);
        PowerMockito.whenNew(RestClusterClient.class).withAnyArguments().thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Configuration config = (Configuration)args[0];
            Assert.assertEquals((Object)host, (Object)config.getString(RestOptions.ADDRESS));
            Assert.assertEquals((long)port, (long)config.getInteger(RestOptions.PORT));
            return mockedClient;
        });
        Configuration clientConfiguration = new Configuration();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (Configuration)clientConfiguration, (String[])new String[0]);
        env.fromElements((Object[])new Integer[]{1}).map((MapFunction & Serializable)x -> x * 2);
        JobExecutionResult actualResult = env.execute("fakeJobName");
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testRemoteExecutionWithSavepoint() throws Exception {
        SavepointRestoreSettings restoreSettings = SavepointRestoreSettings.forPath((String)"fakePath");
        RemoteStreamEnvironment env = new RemoteStreamEnvironment("fakeHost", 1, null, new String[0], null, restoreSettings);
        env.fromElements((Object[])new Integer[]{1}).map((MapFunction & Serializable)x -> x * 2);
        RestClusterClient mockedClient = (RestClusterClient)Mockito.mock(RestClusterClient.class);
        JobExecutionResult expectedResult = new JobExecutionResult(null, 0L, null);
        PowerMockito.whenNew(RestClusterClient.class).withAnyArguments().thenReturn((Object)mockedClient);
        Mockito.when((Object)mockedClient.run((FlinkPlan)Mockito.any(), (List)Mockito.any(), (List)Mockito.any(), (ClassLoader)Mockito.any(), (SavepointRestoreSettings)Mockito.eq((Object)restoreSettings))).thenReturn((Object)expectedResult);
        JobExecutionResult actualResult = env.execute("fakeJobName");
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }
}

