/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.FieldAccessorFactory;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessorTest {
    @Test
    public void testFlatTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)5);
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0", null);
        Assert.assertEquals((Object)"aa", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"aa", (Object)t.f0);
        t = (Tuple2)f0.set((Object)t, (Object)"b");
        Assert.assertEquals((Object)"b", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"b", (Object)t.f0);
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        Assert.assertEquals((long)5L, (long)((Integer)f1.get((Object)t)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)t.f1).intValue());
        t = (Tuple2)f1.set((Object)t, (Object)7);
        Assert.assertEquals((long)7L, (long)((Integer)f1.get((Object)t)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)t.f1).intValue());
        Assert.assertEquals((Object)"b", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"b", (Object)t.f0);
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assert.assertEquals((long)7L, (long)((Integer)f1n.get((Object)t)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)t.f1).intValue());
        t = (Tuple2)f1n.set((Object)t, (Object)10);
        Assert.assertEquals((long)10L, (long)((Integer)f1n.get((Object)t)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)f1.get((Object)t)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)t.f1).intValue());
        Assert.assertEquals((Object)"b", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"b", (Object)t.f0);
        FieldAccessor f1ns = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"1", null);
        Assert.assertEquals((long)10L, (long)((Integer)f1ns.get((Object)t)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)t.f1).intValue());
        t = (Tuple2)f1ns.set((Object)t, (Object)11);
        Assert.assertEquals((long)11L, (long)((Integer)f1ns.get((Object)t)).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)f1.get((Object)t)).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)t.f1).intValue());
        Assert.assertEquals((Object)"b", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"b", (Object)t.f0);
        FieldAccessor f0f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0.0", null);
        Assert.assertEquals((Object)"b", (Object)f0f0.get((Object)t));
        Assert.assertEquals((Object)"b", (Object)t.f0);
        t = (Tuple2)f0f0.set((Object)t, (Object)"cc");
        Assert.assertEquals((Object)"cc", (Object)f0f0.get((Object)t));
        Assert.assertEquals((Object)"cc", (Object)t.f0);
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testIllegalFlatTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)5);
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"illegal", null);
    }

    @Test
    public void testTupleInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)Tuple3.of((Object)5, (Object)9L, (Object)2.0));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0", null);
        Assert.assertEquals((Object)"aa", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"aa", (Object)t.f0);
        FieldAccessor f1f2 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.f2", null);
        Assert.assertEquals((double)2.0, (double)((Double)f1f2.get((Object)t)), (double)0.0);
        Assert.assertEquals((double)2.0, (double)((Double)((Tuple3)t.f1).f2), (double)0.0);
        t = (Tuple2)f1f2.set((Object)t, (Object)3.0);
        Assert.assertEquals((double)3.0, (double)((Double)f1f2.get((Object)t)), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((Double)((Tuple3)t.f1).f2), (double)0.0);
        Assert.assertEquals((Object)"aa", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"aa", (Object)t.f0);
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        Assert.assertEquals((Object)Tuple3.of((Object)5, (Object)9L, (Object)3.0), (Object)f1.get((Object)t));
        Assert.assertEquals((Object)Tuple3.of((Object)5, (Object)9L, (Object)3.0), (Object)t.f1);
        t = (Tuple2)f1.set((Object)t, (Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        Assert.assertEquals((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0), (Object)f1.get((Object)t));
        Assert.assertEquals((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0), (Object)t.f1);
        Assert.assertEquals((Object)"aa", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"aa", (Object)t.f0);
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assert.assertEquals((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0), (Object)f1n.get((Object)t));
        Assert.assertEquals((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0), (Object)t.f1);
        t = (Tuple2)f1n.set((Object)t, (Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0));
        Assert.assertEquals((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0), (Object)f1n.get((Object)t));
        Assert.assertEquals((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0), (Object)f1.get((Object)t));
        Assert.assertEquals((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0), (Object)t.f1);
        Assert.assertEquals((Object)"aa", (Object)f0.get((Object)t));
        Assert.assertEquals((Object)"aa", (Object)t.f0);
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testIllegalTupleField() {
        FieldAccessorFactory.getAccessor((TypeInformation)TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class}), (int)2, null);
    }

    @Test
    public void testTupleInPojoInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f1tf1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.t.f1", null);
        Assert.assertEquals((long)9L, (long)((Long)f1tf1.get((Object)t)));
        Assert.assertEquals((long)9L, (long)((Long)((Foo)t.f1).t.f1));
        t = (Tuple2)f1tf1.set((Object)t, (Object)12L);
        Assert.assertEquals((long)12L, (long)((Long)f1tf1.get((Object)t)));
        Assert.assertEquals((long)12L, (long)((Long)((Foo)t.f1).t.f1));
        FieldAccessor f1tf0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.t.f0", null);
        Assert.assertEquals((Object)"ddd", (Object)f1tf0.get((Object)t));
        Assert.assertEquals((Object)"ddd", (Object)((Foo)t.f1).t.f0);
        t = (Tuple2)f1tf0.set((Object)t, (Object)"alma");
        Assert.assertEquals((Object)"alma", (Object)f1tf0.get((Object)t));
        Assert.assertEquals((Object)"alma", (Object)((Foo)t.f1).t.f0);
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assert.assertEquals((Object)Tuple2.of((Object)"alma", (Object)12L), ((Foo)f1.get((Object)t)).t);
        Assert.assertEquals((Object)Tuple2.of((Object)"alma", (Object)12L), ((Foo)f1n.get((Object)t)).t);
        Assert.assertEquals((Object)Tuple2.of((Object)"alma", (Object)12L), ((Foo)t.f1).t);
        Foo newFoo = new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2);
        f1.set((Object)t, (Object)newFoo);
        Assert.assertEquals((Object)newFoo, (Object)f1.get((Object)t));
        Assert.assertEquals((Object)newFoo, (Object)f1n.get((Object)t));
        Assert.assertEquals((Object)newFoo, (Object)t.f1);
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testIllegalTupleInPojoInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"illegal.illegal.illegal", null);
    }

    @Test
    public void testPojoInPojo() {
        Outer o = new Outer(10, new Inner(4L), 12);
        PojoTypeInfo tpeInfo = (PojoTypeInfo)TypeInformation.of(Outer.class);
        FieldAccessor fix = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"i.x", null);
        Assert.assertEquals((long)4L, (long)((Long)fix.get((Object)o)));
        Assert.assertEquals((long)4L, (long)o.i.x);
        o = (Outer)fix.set((Object)o, (Object)22L);
        Assert.assertEquals((long)22L, (long)((Long)fix.get((Object)o)));
        Assert.assertEquals((long)22L, (long)o.i.x);
        FieldAccessor fi = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"i", null);
        Assert.assertEquals((long)22L, (long)((Inner)fi.get((Object)o)).x);
        Assert.assertEquals((long)22L, (long)((Long)fix.get((Object)o)));
        Assert.assertEquals((long)22L, (long)o.i.x);
        o = (Outer)fi.set((Object)o, (Object)new Inner(30L));
        Assert.assertEquals((long)30L, (long)((Inner)fi.get((Object)o)).x);
        Assert.assertEquals((long)30L, (long)((Long)fix.get((Object)o)));
        Assert.assertEquals((long)30L, (long)o.i.x);
    }

    @Test
    public void testArray() {
        int[] a = new int[]{3, 5};
        FieldAccessor fieldAccessor = FieldAccessorFactory.getAccessor((TypeInformation)PrimitiveArrayTypeInfo.getInfoFor(a.getClass()), (int)1, null);
        Assert.assertEquals(Integer.class, (Object)fieldAccessor.getFieldType().getTypeClass());
        Assert.assertEquals((Object)a[1], (Object)fieldAccessor.get((Object)a));
        a = (int[])fieldAccessor.set((Object)a, (Object)6);
        Assert.assertEquals((Object)a[1], (Object)fieldAccessor.get((Object)a));
        Integer[] b = new Integer[]{3, 5};
        FieldAccessor fieldAccessor2 = FieldAccessorFactory.getAccessor((TypeInformation)BasicArrayTypeInfo.getInfoFor(b.getClass()), (int)1, null);
        Assert.assertEquals(Integer.class, (Object)fieldAccessor2.getFieldType().getTypeClass());
        Assert.assertEquals((Object)b[1], (Object)fieldAccessor2.get((Object)b));
        b = (Integer[])fieldAccessor2.set((Object)b, (Object)6);
        Assert.assertEquals((Object)b[1], (Object)fieldAccessor2.get((Object)b));
    }

    @Test
    public void testArrayInPojo() {
        ArrayInPojo o = new ArrayInPojo(10L, new int[]{3, 4, 5}, 12);
        PojoTypeInfo tpeInfo = (PojoTypeInfo)TypeInformation.of(ArrayInPojo.class);
        FieldAccessor fix = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"arr.1", null);
        Assert.assertEquals((long)4L, (long)((Integer)fix.get((Object)o)).intValue());
        Assert.assertEquals((long)4L, (long)o.arr[1]);
        o = (ArrayInPojo)fix.set((Object)o, (Object)8);
        Assert.assertEquals((long)8L, (long)((Integer)fix.get((Object)o)).intValue());
        Assert.assertEquals((long)8L, (long)o.arr[1]);
    }

    @Test
    public void testBasicType() {
        Long x = 7L;
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        FieldAccessor f = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)0, null);
        Assert.assertEquals((long)7L, (long)((Long)f.get((Object)x)));
        x = (Long)f.set((Object)x, (Object)12L);
        Assert.assertEquals((long)12L, (long)((Long)f.get((Object)x)));
        Assert.assertEquals((long)12L, (long)x);
        FieldAccessor f2 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"*", null);
        Assert.assertEquals((long)12L, (long)((Long)f2.get((Object)x)));
        x = (Long)f2.set((Object)x, (Object)14L);
        Assert.assertEquals((long)14L, (long)((Long)f2.get((Object)x)));
        Assert.assertEquals((long)14L, (long)x);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalBasicType1() {
        Long x = 7L;
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        FieldAccessor f = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalBasicType2() {
        Long x = 7L;
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        FieldAccessor f = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"foo", null);
    }

    public static class ArrayInPojo {
        public long x;
        public int[] arr;
        public int y;

        public ArrayInPojo() {
        }

        public ArrayInPojo(long x, int[] arr, int y) {
            this.x = x;
            this.arr = arr;
            this.y = y;
        }
    }

    public static class Outer {
        public int a;
        public Inner i;
        public short b;

        public Outer() {
        }

        public Outer(int a, Inner i, short b) {
            this.a = a;
            this.i = i;
            this.b = b;
        }

        public String toString() {
            return this.a + ", " + this.i.toString() + ", " + this.b;
        }
    }

    public static class Inner {
        public long x;
        public boolean b;

        public Inner() {
        }

        public Inner(long x) {
            this.x = x;
        }

        public Inner(long x, boolean b) {
            this.x = x;
            this.b = b;
        }

        public String toString() {
            return Long.valueOf(this.x).toString() + ", " + this.b;
        }
    }

    public static class Foo {
        public int x;
        public Tuple2<String, Long> t;
        public Short y;

        public Foo() {
        }

        public Foo(int x, Tuple2<String, Long> t, Short y) {
            this.x = x;
            this.t = t;
            this.y = y;
        }
    }
}

