/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.util.CollectingSourceContext;
import org.mockito.Mockito;

public class SourceFunctionUtil {
    public static <T extends Serializable> List<T> runSourceFunction(SourceFunction<T> sourceFunction) throws Exception {
        if (sourceFunction instanceof RichFunction) {
            return SourceFunctionUtil.runRichSourceFunction(sourceFunction);
        }
        return SourceFunctionUtil.runNonRichSourceFunction(sourceFunction);
    }

    private static <T extends Serializable> List<T> runRichSourceFunction(SourceFunction<T> sourceFunction) throws Exception {
        try (MockEnvironment environment = new MockEnvironmentBuilder().setTaskName("MockTask").setMemorySize(0x300000L).setInputSplitProvider(new MockInputSplitProvider()).setBufferSize(1024).build();){
            AbstractStreamOperator operator = (AbstractStreamOperator)Mockito.mock(AbstractStreamOperator.class);
            Mockito.when((Object)operator.getExecutionConfig()).thenReturn((Object)new ExecutionConfig());
            StreamingRuntimeContext runtimeContext = new StreamingRuntimeContext(operator, (Environment)environment, new HashMap());
            ((RichFunction)sourceFunction).setRuntimeContext((RuntimeContext)runtimeContext);
            ((RichFunction)sourceFunction).open(new Configuration());
            List<T> list = SourceFunctionUtil.runNonRichSourceFunction(sourceFunction);
            return list;
        }
    }

    private static <T extends Serializable> List<T> runNonRichSourceFunction(SourceFunction<T> sourceFunction) {
        ArrayList outputs = new ArrayList();
        try {
            CollectingSourceContext ctx = new CollectingSourceContext(new Object(), outputs);
            sourceFunction.run(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoke source.", e);
        }
        return outputs;
    }
}

