/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.util.Preconditions;

public class OneInputStreamOperatorTestHarness<IN, OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    private final OneInputStreamOperator<IN, OUT> oneInputOperator;
    private long currentWatermark;

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> typeSerializerIn) throws Exception {
        this(operator, 1, 1, 0);
        this.config.setTypeSerializerIn1((TypeSerializer)Preconditions.checkNotNull(typeSerializerIn));
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, int maxParallelism, int parallelism, int subtaskIndex, TypeSerializer<IN> typeSerializerIn, OperatorID operatorID) throws Exception {
        this(operator, maxParallelism, parallelism, subtaskIndex, operatorID);
        this.config.setTypeSerializerIn1((TypeSerializer)Preconditions.checkNotNull(typeSerializerIn));
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> typeSerializerIn, MockEnvironment environment) throws Exception {
        this(operator, environment);
        this.config.setTypeSerializerIn1((TypeSerializer)Preconditions.checkNotNull(typeSerializerIn));
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator) throws Exception {
        this(operator, 1, 1, 0);
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, int maxParallelism, int parallelism, int subtaskIndex) throws Exception {
        this(operator, maxParallelism, parallelism, subtaskIndex, new OperatorID());
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, int maxParallelism, int parallelism, int subtaskIndex, OperatorID operatorID) throws Exception {
        super(operator, maxParallelism, parallelism, subtaskIndex, operatorID);
        this.oneInputOperator = operator;
    }

    public OneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, MockEnvironment environment) throws Exception {
        super(operator, environment);
        this.oneInputOperator = operator;
    }

    public void processElement(IN value, long timestamp) throws Exception {
        this.processElement(new StreamRecord(value, timestamp));
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.operator.setKeyContextElement1(element);
        this.oneInputOperator.processElement(element);
    }

    public void processElements(Collection<StreamRecord<IN>> elements) throws Exception {
        for (StreamRecord<IN> element : elements) {
            this.operator.setKeyContextElement1(element);
            this.oneInputOperator.processElement(element);
        }
    }

    public void processWatermark(long watermark) throws Exception {
        this.processWatermark(new Watermark(watermark));
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.currentWatermark = mark.getTimestamp();
        this.oneInputOperator.processWatermark(mark);
    }

    public long getCurrentWatermark() {
        return this.currentWatermark;
    }
}

