/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.util.Preconditions;

public class ContentDump {
    private boolean writable = true;
    private Map<String, List<String>> filesContent = new HashMap<String, List<String>>();

    public Set<String> listFiles() {
        return new HashSet<String>(this.filesContent.keySet());
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public ContentWriter createWriter(String name) {
        Preconditions.checkArgument((!this.filesContent.containsKey(name) ? 1 : 0) != 0, (String)"File [%s] already exists", (Object[])new Object[]{name});
        this.filesContent.put(name, new ArrayList());
        return new ContentWriter(name, this);
    }

    public static void move(String name, ContentDump source, ContentDump target) {
        Collection<String> content = source.read(name);
        try (ContentWriter contentWriter = target.createWriter(name);){
            contentWriter.write(content).flush();
        }
        source.delete(name);
    }

    public void delete(String name) {
        this.filesContent.remove(name);
    }

    public Collection<String> read(String name) {
        List<String> content = this.filesContent.get(name);
        Preconditions.checkState((content != null ? 1 : 0) != 0, (String)"Unknown file [%s]", (Object[])new Object[]{name});
        ArrayList<String> result = new ArrayList<String>(content);
        return result;
    }

    private void putContent(String name, List<String> values) {
        List<String> content = this.filesContent.get(name);
        Preconditions.checkState((content != null ? 1 : 0) != 0, (String)"Unknown file [%s]", (Object[])new Object[]{name});
        if (!this.writable) {
            throw new NotWritableException(name);
        }
        content.addAll(values);
    }

    public class NotWritableException
    extends RuntimeException {
        public NotWritableException(String name) {
            super(String.format("File [%s] is not writable", name));
        }
    }

    public static class ContentWriter
    implements AutoCloseable {
        private final ContentDump contentDump;
        private final String name;
        private final List<String> buffer = new ArrayList<String>();
        private boolean closed = false;

        private ContentWriter(String name, ContentDump contentDump) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.contentDump = (ContentDump)Preconditions.checkNotNull((Object)contentDump);
        }

        public String getName() {
            return this.name;
        }

        public ContentWriter write(String value) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.buffer.add(value);
            return this;
        }

        public ContentWriter write(Collection<String> values) {
            values.forEach(this::write);
            return this;
        }

        public ContentWriter flush() {
            this.contentDump.putContent(this.name, this.buffer);
            return this;
        }

        @Override
        public void close() {
            this.buffer.clear();
            this.closed = true;
        }
    }
}

