/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyGroupStreamPartitionerTest
extends TestLogger {
    private KeyGroupStreamPartitioner<Tuple2<String, Integer>, String> keyGroupPartitioner;
    private StreamRecord<Tuple2<String, Integer>> streamRecord1 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)0));
    private StreamRecord<Tuple2<String, Integer>> streamRecord2 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)42));
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> sd1 = new SerializationDelegate(null);
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> sd2 = new SerializationDelegate(null);

    @Before
    public void setPartitioner() {
        this.keyGroupPartitioner = new KeyGroupStreamPartitioner((KeySelector)new KeySelector<Tuple2<String, Integer>, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple2<String, Integer> value) throws Exception {
                return (String)value.getField(0);
            }
        }, 1024);
    }

    @Test
    public void testSelectChannelsLength() {
        this.sd1.setInstance(this.streamRecord1);
        Assert.assertEquals((long)1L, (long)this.keyGroupPartitioner.selectChannels(this.sd1, 1).length);
        Assert.assertEquals((long)1L, (long)this.keyGroupPartitioner.selectChannels(this.sd1, 2).length);
        Assert.assertEquals((long)1L, (long)this.keyGroupPartitioner.selectChannels(this.sd1, 1024).length);
    }

    @Test
    public void testSelectChannelsGrouping() {
        this.sd1.setInstance(this.streamRecord1);
        this.sd2.setInstance(this.streamRecord2);
        Assert.assertArrayEquals((int[])this.keyGroupPartitioner.selectChannels(this.sd1, 1), (int[])this.keyGroupPartitioner.selectChannels(this.sd2, 1));
        Assert.assertArrayEquals((int[])this.keyGroupPartitioner.selectChannels(this.sd1, 2), (int[])this.keyGroupPartitioner.selectChannels(this.sd2, 2));
        Assert.assertArrayEquals((int[])this.keyGroupPartitioner.selectChannels(this.sd1, 1024), (int[])this.keyGroupPartitioner.selectChannels(this.sd2, 1024));
    }
}

