/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalMergingState;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TestInternalTimerService;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class TriggerTestHarness<T, W extends Window> {
    private static final Integer KEY = 1;
    private final Trigger<T, W> trigger;
    private final TypeSerializer<W> windowSerializer;
    private final HeapKeyedStateBackend<Integer> stateBackend;
    private final TestInternalTimerService<Integer, W> internalTimerService;

    public TriggerTestHarness(Trigger<T, W> trigger, TypeSerializer<W> windowSerializer) throws Exception {
        HeapKeyedStateBackend stateBackend;
        this.trigger = trigger;
        this.windowSerializer = windowSerializer;
        DummyEnvironment dummyEnv = new DummyEnvironment("test", 1, 0);
        MemoryStateBackend backend = new MemoryStateBackend();
        this.stateBackend = stateBackend = (HeapKeyedStateBackend)backend.createKeyedStateBackend((Environment)dummyEnv, new JobID(), "test_op", (TypeSerializer)IntSerializer.INSTANCE, 1, new KeyGroupRange(0, 0), new KvStateRegistry().createTaskRegistry(new JobID(), new JobVertexID()));
        this.stateBackend.setCurrentKey((Object)KEY);
        this.internalTimerService = new TestInternalTimerService(new KeyContext(){

            public void setCurrentKey(Object key) {
            }

            public Object getCurrentKey() {
                return KEY;
            }
        });
    }

    public int numProcessingTimeTimers() {
        return this.internalTimerService.numProcessingTimeTimers();
    }

    public int numProcessingTimeTimers(W window) {
        return this.internalTimerService.numProcessingTimeTimers(window);
    }

    public int numEventTimeTimers() {
        return this.internalTimerService.numEventTimeTimers();
    }

    public int numEventTimeTimers(W window) {
        return this.internalTimerService.numEventTimeTimers(window);
    }

    public int numStateEntries() {
        return this.stateBackend.numKeyValueStateEntries();
    }

    public int numStateEntries(W window) {
        return this.stateBackend.numKeyValueStateEntries(window);
    }

    public TriggerResult processElement(StreamRecord<T> element, W window) throws Exception {
        TestTriggerContext<Integer, W> triggerContext = new TestTriggerContext<Integer, W>(KEY, window, this.internalTimerService, (KeyedStateBackend<Integer>)this.stateBackend, this.windowSerializer);
        return this.trigger.onElement(element.getValue(), element.getTimestamp(), window, triggerContext);
    }

    public TriggerResult advanceProcessingTime(long time, W window) throws Exception {
        Collection<Tuple2<W, TriggerResult>> firings = this.advanceProcessingTime(time);
        if (firings.size() != 1) {
            throw new IllegalStateException("Must have exactly one timer firing. Fired timers: " + firings);
        }
        Tuple2<W, TriggerResult> firing = firings.iterator().next();
        if (!((Window)firing.f0).equals(window)) {
            throw new IllegalStateException("Trigger fired for another window.");
        }
        return (TriggerResult)firing.f1;
    }

    public TriggerResult advanceWatermark(long time, W window) throws Exception {
        Collection<Tuple2<W, TriggerResult>> firings = this.advanceWatermark(time);
        if (firings.size() != 1) {
            throw new IllegalStateException("Must have exactly one timer firing. Fired timers: " + firings);
        }
        Tuple2<W, TriggerResult> firing = firings.iterator().next();
        if (!((Window)firing.f0).equals(window)) {
            throw new IllegalStateException("Trigger fired for another window.");
        }
        return (TriggerResult)firing.f1;
    }

    public Collection<Tuple2<W, TriggerResult>> advanceProcessingTime(long time) throws Exception {
        Collection<TestInternalTimerService.Timer<Integer, W>> firedTimers = this.internalTimerService.advanceProcessingTime(time);
        ArrayList<Tuple2<W, TriggerResult>> result = new ArrayList<Tuple2<W, TriggerResult>>();
        for (TestInternalTimerService.Timer<Integer, W> timer : firedTimers) {
            TestTriggerContext<Integer, Window> triggerContext = new TestTriggerContext<Integer, Window>(KEY, (Window)timer.getNamespace(), (InternalTimerService<Window>)this.internalTimerService, (KeyedStateBackend<Integer>)this.stateBackend, (TypeSerializer<Window>)this.windowSerializer);
            TriggerResult triggerResult = this.trigger.onProcessingTime(timer.getTimestamp(), (Window)timer.getNamespace(), triggerContext);
            result.add(new Tuple2(timer.getNamespace(), (Object)triggerResult));
        }
        return result;
    }

    public Collection<Tuple2<W, TriggerResult>> advanceWatermark(long time) throws Exception {
        Collection<TestInternalTimerService.Timer<Integer, W>> firedTimers = this.internalTimerService.advanceWatermark(time);
        ArrayList<Tuple2<W, TriggerResult>> result = new ArrayList<Tuple2<W, TriggerResult>>();
        for (TestInternalTimerService.Timer<Integer, W> timer : firedTimers) {
            TriggerResult triggerResult = this.invokeOnEventTime(timer);
            result.add(new Tuple2(timer.getNamespace(), (Object)triggerResult));
        }
        return result;
    }

    private TriggerResult invokeOnEventTime(TestInternalTimerService.Timer<Integer, W> timer) throws Exception {
        TestTriggerContext<Integer, Window> triggerContext = new TestTriggerContext<Integer, Window>(KEY, (Window)timer.getNamespace(), (InternalTimerService<Window>)this.internalTimerService, (KeyedStateBackend<Integer>)this.stateBackend, (TypeSerializer<Window>)this.windowSerializer);
        return this.trigger.onEventTime(timer.getTimestamp(), (Window)timer.getNamespace(), triggerContext);
    }

    public TriggerResult invokeOnEventTime(long timestamp, W window) throws Exception {
        TestInternalTimerService.Timer<Integer, W> timer = new TestInternalTimerService.Timer<Integer, W>(timestamp, KEY, window);
        return this.invokeOnEventTime(timer);
    }

    public void mergeWindows(W targetWindow, Collection<W> mergedWindows) throws Exception {
        TestOnMergeContext<Integer, W> onMergeContext = new TestOnMergeContext<Integer, W>(KEY, targetWindow, mergedWindows, this.internalTimerService, (KeyedStateBackend<Integer>)this.stateBackend, this.windowSerializer);
        this.trigger.onMerge(targetWindow, onMergeContext);
        for (Window mergedWindow : mergedWindows) {
            this.clearTriggerState(mergedWindow);
        }
    }

    public void clearTriggerState(W window) throws Exception {
        TestTriggerContext<Integer, W> triggerContext = new TestTriggerContext<Integer, W>(KEY, window, this.internalTimerService, (KeyedStateBackend<Integer>)this.stateBackend, this.windowSerializer);
        this.trigger.clear(window, triggerContext);
    }

    private static class TestOnMergeContext<K, W extends Window>
    extends TestTriggerContext<K, W>
    implements Trigger.OnMergeContext {
        private final Collection<W> mergedWindows;

        public TestOnMergeContext(K key, W targetWindow, Collection<W> mergedWindows, InternalTimerService<W> timerService, KeyedStateBackend<Integer> stateBackend, TypeSerializer<W> windowSerializer) {
            super(key, targetWindow, timerService, stateBackend, windowSerializer);
            this.mergedWindows = mergedWindows;
        }

        public <S extends MergingState<?, ?>> void mergePartitionedState(StateDescriptor<S, ?> stateDescriptor) {
            try {
                MergingState rawState = (MergingState)this.stateBackend.getOrCreateKeyedState(this.windowSerializer, stateDescriptor);
                if (!(rawState instanceof InternalMergingState)) {
                    throw new IllegalArgumentException("The given state descriptor does not refer to a mergeable state (MergingState)");
                }
                InternalMergingState mergingState = (InternalMergingState)rawState;
                mergingState.mergeNamespaces((Object)this.window, this.mergedWindows);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while merging state.", e);
            }
        }
    }

    private static class TestTriggerContext<K, W extends Window>
    implements Trigger.TriggerContext {
        protected final InternalTimerService<W> timerService;
        protected final KeyedStateBackend<Integer> stateBackend;
        protected final K key;
        protected final W window;
        protected final TypeSerializer<W> windowSerializer;

        TestTriggerContext(K key, W window, InternalTimerService<W> timerService, KeyedStateBackend<Integer> stateBackend, TypeSerializer<W> windowSerializer) {
            this.key = key;
            this.window = window;
            this.timerService = timerService;
            this.stateBackend = stateBackend;
            this.windowSerializer = windowSerializer;
        }

        public long getCurrentProcessingTime() {
            return this.timerService.currentProcessingTime();
        }

        public MetricGroup getMetricGroup() {
            return null;
        }

        public long getCurrentWatermark() {
            return this.timerService.currentWatermark();
        }

        public void registerProcessingTimeTimer(long time) {
            this.timerService.registerProcessingTimeTimer(this.window, time);
        }

        public void registerEventTimeTimer(long time) {
            this.timerService.registerEventTimeTimer(this.window, time);
        }

        public void deleteProcessingTimeTimer(long time) {
            this.timerService.deleteProcessingTimeTimer(this.window, time);
        }

        public void deleteEventTimeTimer(long time) {
            this.timerService.deleteEventTimeTimer(this.window, time);
        }

        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) {
            try {
                return (S)this.stateBackend.getPartitionedState(this.window, this.windowSerializer, stateDescriptor);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting state", e);
            }
        }

        public <S extends Serializable> ValueState<S> getKeyValueState(String name, Class<S> stateType, S defaultState) {
            return (ValueState)this.getPartitionedState((StateDescriptor<S, ?>)new ValueStateDescriptor(name, stateType, defaultState));
        }

        public <S extends Serializable> ValueState<S> getKeyValueState(String name, TypeInformation<S> stateType, S defaultState) {
            return (ValueState)this.getPartitionedState((StateDescriptor<S, ?>)new ValueStateDescriptor(name, stateType, defaultState));
        }
    }
}

