/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.DynamicEventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.StreamRecordMatchers;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class EventTimeSessionWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        int sessionGap = 5000;
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)5000L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4999L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(4999L, 9999L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5000L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testMergeSinglePointWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)5000L));
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 0L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeSingleWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)5000L));
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 1L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeConsecutiveWindows() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)5000L));
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)})), Mockito.eq((Object)new TimeWindow(0L, 3L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)})), Mockito.eq((Object)new TimeWindow(4L, 6L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeCoveringWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)5000L));
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L), new TimeWindow(4L, 7L), new TimeWindow(5L, 6L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L)})), Mockito.eq((Object)new TimeWindow(0L, 2L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 6L), new TimeWindow(4L, 7L)})), Mockito.eq((Object)new TimeWindow(4L, 7L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testTimeUnits() {
        int sessionGap = 5000;
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4999L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(4999L, 9999L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5000L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testInvalidParameters() {
        try {
            EventTimeSessionWindows.withGap((Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 < size"));
        }
        try {
            EventTimeSessionWindows.withGap((Time)Time.seconds((long)0L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 < size"));
        }
    }

    @Test
    public void testProperties() {
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger((StreamExecutionEnvironment)Mockito.mock(StreamExecutionEnvironment.class)), (Matcher)Matchers.instanceOf(EventTimeTrigger.class));
    }

    @Test
    public void testDynamicGapProperties() {
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        DynamicEventTimeSessionWindows assigner = EventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Assert.assertNotNull((Object)assigner);
        Assert.assertTrue((boolean)assigner.isEventTime());
    }
}

