/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.util.CollectorOutput;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StreamSourceOperatorLatencyMetricsTest
extends TestLogger {
    private static final long maxProcessingTime = 100L;
    private static final long latencyMarkInterval = 10L;

    @Test
    public void testLatencyMarkEmissionDisabled() throws Exception {
        this.testLatencyMarkEmission(0, (operator, timeProvider) -> StreamSourceOperatorLatencyMetricsTest.setupSourceOperator(operator, new ExecutionConfig(), (Environment)MockEnvironment.builder().build(), (ProcessingTimeService)timeProvider));
    }

    @Test
    public void testLatencyMarkEmissionEnabledViaExecutionConfig() throws Exception {
        this.testLatencyMarkEmission(11, (operator, timeProvider) -> {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.setLatencyTrackingInterval(10L);
            StreamSourceOperatorLatencyMetricsTest.setupSourceOperator(operator, executionConfig, (Environment)MockEnvironment.builder().build(), (ProcessingTimeService)timeProvider);
        });
    }

    @Test
    public void testLatencyMarkEmissionEnabledViaFlinkConfig() throws Exception {
        this.testLatencyMarkEmission(11, (operator, timeProvider) -> {
            Configuration tmConfig = new Configuration();
            tmConfig.setLong(MetricOptions.LATENCY_INTERVAL, 10L);
            MockEnvironment env = MockEnvironment.builder().setTaskManagerRuntimeInfo((TaskManagerRuntimeInfo)new TestingTaskManagerRuntimeInfo(tmConfig)).build();
            StreamSourceOperatorLatencyMetricsTest.setupSourceOperator(operator, new ExecutionConfig(), (Environment)env, (ProcessingTimeService)timeProvider);
        });
    }

    @Test
    public void testLatencyMarkEmissionEnabledOverrideViaExecutionConfig() throws Exception {
        this.testLatencyMarkEmission(11, (operator, timeProvider) -> {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.setLatencyTrackingInterval(10L);
            Configuration tmConfig = new Configuration();
            tmConfig.setLong(MetricOptions.LATENCY_INTERVAL, 0L);
            MockEnvironment env = MockEnvironment.builder().setTaskManagerRuntimeInfo((TaskManagerRuntimeInfo)new TestingTaskManagerRuntimeInfo(tmConfig)).build();
            StreamSourceOperatorLatencyMetricsTest.setupSourceOperator(operator, executionConfig, (Environment)env, (ProcessingTimeService)timeProvider);
        });
    }

    @Test
    public void testLatencyMarkEmissionDisabledOverrideViaExecutionConfig() throws Exception {
        this.testLatencyMarkEmission(0, (operator, timeProvider) -> {
            Configuration tmConfig = new Configuration();
            tmConfig.setLong(MetricOptions.LATENCY_INTERVAL, 10L);
            MockEnvironment env = MockEnvironment.builder().setTaskManagerRuntimeInfo((TaskManagerRuntimeInfo)new TestingTaskManagerRuntimeInfo(tmConfig)).build();
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.setLatencyTrackingInterval(0L);
            StreamSourceOperatorLatencyMetricsTest.setupSourceOperator(operator, executionConfig, (Environment)env, (ProcessingTimeService)timeProvider);
        });
    }

    private void testLatencyMarkEmission(int numberLatencyMarkers, OperatorSetupOperation operatorSetup) throws Exception {
        int i;
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        TestProcessingTimeService testProcessingTimeService = new TestProcessingTimeService();
        testProcessingTimeService.setCurrentTime(0L);
        List<Long> processingTimes = Arrays.asList(1L, 10L, 11L, 21L, 100L);
        StreamSource operator = new StreamSource((SourceFunction)new ProcessingTimeServiceSource(testProcessingTimeService, processingTimes));
        operatorSetup.setupSourceOperator(operator, testProcessingTimeService);
        operator.run(new Object(), (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class), new CollectorOutput(output));
        Assert.assertEquals((long)(numberLatencyMarkers + 1), (long)output.size());
        long timestamp = 0L;
        for (i = 0; i < numberLatencyMarkers; ++i) {
            StreamElement se = (StreamElement)output.get(i);
            Assert.assertTrue((boolean)se.isLatencyMarker());
            Assert.assertEquals((Object)operator.getOperatorID(), (Object)se.asLatencyMarker().getOperatorId());
            Assert.assertEquals((long)0L, (long)se.asLatencyMarker().getSubtaskIndex());
            Assert.assertTrue((se.asLatencyMarker().getMarkedTime() == timestamp ? 1 : 0) != 0);
            timestamp += 10L;
        }
        Assert.assertTrue((boolean)((StreamElement)output.get(i)).isWatermark());
    }

    private static <T> void setupSourceOperator(StreamSource<T, ?> operator, ExecutionConfig executionConfig, Environment env, final ProcessingTimeService timeProvider) {
        StreamConfig cfg = new StreamConfig(new Configuration());
        cfg.setStateBackend((StateBackend)new MemoryStateBackend());
        cfg.setTimeCharacteristic(TimeCharacteristic.EventTime);
        cfg.setOperatorID(new OperatorID());
        StreamStatusMaintainer streamStatusMaintainer = (StreamStatusMaintainer)Mockito.mock(StreamStatusMaintainer.class);
        Mockito.when((Object)streamStatusMaintainer.getStreamStatus()).thenReturn((Object)StreamStatus.ACTIVE);
        StreamTask mockTask = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)mockTask.getName()).thenReturn((Object)"Mock Task");
        Mockito.when((Object)mockTask.getCheckpointLock()).thenReturn(new Object());
        Mockito.when((Object)mockTask.getConfiguration()).thenReturn((Object)cfg);
        Mockito.when((Object)mockTask.getEnvironment()).thenReturn((Object)env);
        Mockito.when((Object)mockTask.getExecutionConfig()).thenReturn((Object)executionConfig);
        Mockito.when((Object)mockTask.getAccumulatorMap()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)mockTask.getStreamStatusMaintainer()).thenReturn((Object)streamStatusMaintainer);
        ((StreamTask)Mockito.doAnswer((Answer)new Answer<ProcessingTimeService>(){

            public ProcessingTimeService answer(InvocationOnMock invocation) throws Throwable {
                if (timeProvider == null) {
                    throw new RuntimeException("The time provider is null.");
                }
                return timeProvider;
            }
        }).when((Object)mockTask)).getProcessingTimeService();
        operator.setup(mockTask, cfg, (Output)Mockito.mock(Output.class));
    }

    private static final class ProcessingTimeServiceSource
    implements SourceFunction<Long> {
        private final TestProcessingTimeService processingTimeService;
        private final List<Long> processingTimes;
        private boolean cancelled = false;

        private ProcessingTimeServiceSource(TestProcessingTimeService processingTimeService, List<Long> processingTimes) {
            this.processingTimeService = processingTimeService;
            this.processingTimes = processingTimes;
        }

        public void run(SourceFunction.SourceContext<Long> ctx) throws Exception {
            for (Long processingTime : this.processingTimes) {
                if (this.cancelled) break;
                this.processingTimeService.setCurrentTime(processingTime.longValue());
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    private static interface OperatorSetupOperation {
        public void setupSourceOperator(StreamSource<Long, ?> var1, TestProcessingTimeService var2);
    }
}

