/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.streaming.runtime.io.StreamRecordWriter;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Preconditions;

public class LongRecordWriterThread
extends CheckedThread {
    private final StreamRecordWriter<LongValue> recordWriter;
    private final boolean broadcastMode;
    private CompletableFuture<Long> recordsToSend = new CompletableFuture();
    private volatile boolean running = true;

    public LongRecordWriterThread(StreamRecordWriter<LongValue> recordWriter, boolean broadcastMode) {
        this.recordWriter = (StreamRecordWriter)Preconditions.checkNotNull(recordWriter);
        this.broadcastMode = broadcastMode;
    }

    public synchronized void shutdown() {
        this.running = false;
        this.recordsToSend.complete(0L);
    }

    public synchronized void setRecordsToSend(long records) {
        Preconditions.checkState((!this.recordsToSend.isDone() ? 1 : 0) != 0);
        this.recordsToSend.complete(records);
    }

    private synchronized CompletableFuture<Long> getRecordsToSend() {
        return this.recordsToSend;
    }

    private synchronized void finishSendingRecords() {
        this.recordsToSend = new CompletableFuture();
    }

    public void go() throws Exception {
        try {
            while (this.running) {
                this.sendRecords(this.getRecordsToSend().get());
            }
        }
        finally {
            this.recordWriter.close();
        }
    }

    private void sendRecords(long records) throws IOException, InterruptedException {
        LongValue value = new LongValue(0L);
        int i = 1;
        while ((long)i < records) {
            if (this.broadcastMode) {
                this.recordWriter.broadcastEmit((IOReadableWritable)value);
            } else {
                this.recordWriter.emit((IOReadableWritable)value);
            }
            ++i;
        }
        value.setValue(records);
        this.recordWriter.broadcastEmit((IOReadableWritable)value);
        this.recordWriter.flushAll();
        this.finishSendingRecords();
    }
}

