/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.util.StringUtils;

public class TestEvent
extends AbstractEvent {
    private long magicNumber;
    private byte[] payload;

    public TestEvent() {
    }

    public TestEvent(long magicNumber, byte[] payload) {
        this.magicNumber = magicNumber;
        this.payload = payload;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.magicNumber);
        out.writeInt(this.payload.length);
        out.write(this.payload);
    }

    public void read(DataInputView in) throws IOException {
        this.magicNumber = in.readLong();
        this.payload = new byte[in.readInt()];
        in.readFully(this.payload);
    }

    public int hashCode() {
        return Long.valueOf(this.magicNumber).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == TestEvent.class) {
            TestEvent that = (TestEvent)((Object)obj);
            return this.magicNumber == that.magicNumber && Arrays.equals(this.payload, that.payload);
        }
        return false;
    }

    public String toString() {
        return String.format("TestEvent %d (%s)", this.magicNumber, StringUtils.byteToHexString((byte[])this.payload));
    }
}

