/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierBufferTestBase;
import org.apache.flink.streaming.runtime.io.BufferBlocker;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class SpillingBarrierBufferTest
extends BarrierBufferTestBase {
    private static IOManager ioManager;

    @BeforeClass
    public static void setup() {
        ioManager = new IOManagerAsync();
    }

    @AfterClass
    public static void shutdownIOManager() {
        ioManager.shutdown();
    }

    @After
    public void checkNoTempFilesRemain() {
        for (File dir : ioManager.getSpillingDirectories()) {
            for (String file : dir.list()) {
                if (file == null || file.equals(".") || file.equals("..")) continue;
                Assert.fail((String)("barrier buffer did not clean up temp files. remaining file: " + file));
            }
        }
    }

    @Override
    public BarrierBuffer createBarrierHandler(InputGate gate) throws IOException {
        return new BarrierBuffer(gate, (BufferBlocker)new BufferSpiller(ioManager, 512));
    }

    @Override
    public void validateAlignmentBuffered(long actualBytesBuffered, BufferOrEvent ... sequence) {
        long expectedBuffered = 0L;
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer()) continue;
            expectedBuffered += (long)(9 + boe.getBuffer().getSize());
        }
        Assert.assertEquals((String)"Wrong alignment buffered bytes", (long)actualBytesBuffered, (long)expectedBuffered);
    }
}

